function [result]=Newton(x,N1,N2);
% Calculates the maximas and minimas, using Newton method.
% Returns a vector containing the values of psi at 
% the extreme points.
% Written by Johan Skatt, Royal Institute of Technology 1997
% Usage: Newton(x,N1,N2)

a1=x(:,1:N1);
a2=zeros(1,N2);
b2=x(:,N1+1:N1+N2);
b1=x(:,N1+N2+1:2*N1+N2);
C1=x(:,2*N1+N2+1);
a=[a2 a1];
b=[b2 b1];

% Bild up the start psi-vector
psi=[(-pi+b(1))/2];
for n=1:N2-1
  psi=[psi (b(n)+b(n+1))/2];
end
for n=N2:N1+N2-1
  psi=[psi (b(n)+b(n+1))/2 b(n+1)]; 
end
psi=[psi 3];

M=20/log(10);
% The Newton algorithm for finding the zeros.
for n=1:length(psi)
  if psi(n)==0, psi(n)=0.0001; end
  x=psi(n); dx=x; iter=0;
  while abs(dx/x)>1e-4 & iter<20
   D=1-2*exp(a).*cos(x-b)+exp(2*a);		
    Gprim=M*sum(exp(a).*sin(x-b)./D)-M*sin(x)./(2+2*cos(x));
    Q=M/(2+2*cos(x));
    Gbiss=M*sum((exp(a).*((1+exp(2*a)).*cos(x-b)-2*exp(a)))./D.^2)-Q;
    dx=-Gprim/Gbiss; x=x+dx; iter=iter+1;	
  end
  if iter==20,
     disp('You are in trouble here, it does not converge');
  end
  result=[result x];
end
