% Plots the wanted beamform in the theta-plane
% Written by Johan Skatt, Royal Institute of Technology 1997

temp=110*pi/180:0.01:151*pi/180;
plot([0 110],[-20 -20],'c'), hold on;
plot([110 110],[-20 0],'c'), hold on;
S=(csc(temp-pi/2)).^2;
S=S-max(S);
plot(180*temp/pi,S,'c'), hold on;
plot([150 150],[min(S) -30],'c'), hold on;
plot([150 180],[-30 -30],'c'), hold on;

% Ripple +/- 0.5 dB
plot(180*temp/pi,S+0.5,'r--'), hold on;
plot(180*temp/pi,S-0.5,'r--'), hold on;
