; PIC16C84 Pin assignment
				; i/o RA0-RA3 = 4-bit LCD-data bus
DISP_E          equ     1       ;   o RB1 = Display (R/!W) Enable
DISP_RW         equ     2       ;   o RB2 = Display READ/!WRITE
DISP_RS         equ     3       ;   o RB3 = Display Registerselect


; PIC16C84 RAM Register Assignments
INFO		equ	0Ch	; Information storage byte
BF_FLAG		equ	01h
I_FLAG		equ	02h	
DISPDATA        equ     0Fh     ; Next Data to send to display
TIME            equ     10h     ; Down counting of microseconds
STRPTR	        equ     11h     ; General loopcounter


DEFSTR	macro	STRING
	local	STR
STR:	movlw   HIGH STR	; Get higher bits of MESSAGES address
	movwf   PCLATH          ; Make high address OK for computed goto
	addwf	PCL,F		; Get data as computed goto
	dt	STRING		; Store string as PIC-table
	retlw	0		; End-Of-String
	endm

PORTALO	macro
	bsf     STATUS,RP0      ; Set page 1 for getting access to TRIS
	movlw   b'11100000'     ; Set Port A Tristate latches
	movwf   TRISA           ; Store in port a tristate register
	bcf     STATUS,RP0      ; Change back to page 0
	endm

PORTAHI	macro
	bsf     STATUS,RP0      ; Set page 1 for getting access to TRIS
	movlw   b'11101111'     ; Set Port A Tristate latches
	movwf   TRISA           ; Store in port A tristate register
	bcf     STATUS,RP0      ; Change back to page 0
	endm

CLKDISP	macro
	bsf     PORTB,DISP_E    ; Raise Enable pin on display
	bcf     PORTB,DISP_E    ; Lower Enable pin on display
	endm


DISPCLR	macro
	movlw   b'00000001'     ; Display Clear
	call    SENDI           ; Send instruction to display
	endm

LINE1	macro
	movlw	b'10000000'	; Set LCD address to first position
	call	SENDI
	endm

LINE2	macro
	movlw	b'11000000'	; Set LCD address to next line
	call	SENDI
	endm

LCDINIT	macro
	PORTALO			; Set port A as output

	movlw   d'15'           ; Make an inital wait for display in 15 ms
	call    WAIT		; Call wait routine
	movlw   b'00000011'     ; Set 4-bit interface to to display
	movwf   PORTA           ; Send it to port A
	CLKDISP		        ; Clock out to display

	movlw   d'5'            ; Wait 5 ms so display understands 4-bit
	call    WAIT		; Call wait routine

; Data setup startar hr
	movlw   b'00101000'     ; Set 4-bit interface, 2 lines & normal font
	call    SENDI           ; Send instruction to display
	movlw   b'00101000'     ; Set 4-bit interface, 2 lines & normal font
	call    SENDI           ; Send instruction to display
	movlw   b'00001000'     ; Display OFF
	call    SENDI           ; Send instruction to display
	DISPCLR
	movlw   b'00001100'     ; Display ON
	call    SENDI           ; Send instruction
	movlw   b'00000110'     ; Entry mode set to increment/no shift
	call    SENDI           ; Send instruction to display
	endm


PRTSTR	macro	STRING
	local	PRINTLOOP, ENDPRINTLOOP
	clrf	STRPTR		; Clr stringpointer
PRINTLOOP:
	movf	STRPTR,W	; Get stringpointer to W
	call	STRING		; Get letter from string based in index in W
	btfsc	STATUS,Z	; Was it a zero (End-Of-String)?
	goto	ENDPRINTLOOP	; If yes quit this loop
	call	SENDD		; Else send character to display
	incf	STRPTR,F	; Increase stringpointer to next letter
	goto	PRINTLOOP 	; Make the loop
ENDPRINTLOOP:

	endm


; DISPLAY ROUTINES
SENDI:
	bsf     INFO,I_FLAG     ; Next data is an instruction
SENDD:
	movwf   DISPDATA        ; Store send-data for later use
	PORTAHI			; Put PortA tristate

	bcf     PORTB,DISP_RS   ; RS=0 => Instruction
	bsf     PORTB,DISP_RW   ; RW=1 => Read
DISPBUSY:
	bsf     PORTB,DISP_E    ; Display puts data on PortA
	bcf     INFO,BF_FLAG    ; Busy flag is probably = 0
	btfsc   PORTA,3         ; Read busy flag from display
	bsf     INFO,BF_FLAG    ; Busy flag was = 1
	bcf     PORTB,DISP_E    ; Lower display enable port
;	call    CLKDISP         ; Clock out the last and uninteresting nibble
	bsf     PORTB,DISP_E    ; Raise Enable pin on display
	bcf     PORTB,DISP_E    ; Lower Enable pin on display

	btfsc   INFO,BF_FLAG    ; Check if display is ready
	goto    DISPBUSY        ; The display is not ready
;	call    PORTALO         ; Put portA in a low impedance state
	bsf     STATUS,RP0      ; Set page 1 for getting access to TRIS
	movlw   b'11100000'     ; Set Port A Tristate latches
	movwf   TRISA           ; Store in port a tristate register
	bcf     STATUS,RP0      ; Change back to page 0

	bsf     PORTB,DISP_RS   ; RS=1 => Data
	bcf     PORTB,DISP_RW   ; RW=0 => Write
	btfsc   INFO,I_FLAG     ; Check if SENDData?
	bcf     PORTB,DISP_RS   ; No, RS=0 => Instruction
	swapf   DISPDATA,W      ; Put first nibble to send in W-low
	movwf   PORTA           ; Put first nibble to portA
;	call    CLKDISP         ; Clock out the first nibble to display
	bsf     PORTB,DISP_E    ; Raise Enable pin on display
	bcf     PORTB,DISP_E    ; Lower Enable pin on display

	movf    DISPDATA,W      ; Put last nibble to send in W
	movwf   PORTA           ; Put last nibble on portA
;	call    CLKDISP         ; Clock out the last nibble to display
	bsf     PORTB,DISP_E    ; Raise Enable pin on display
	bcf     PORTB,DISP_E    ; Lower Enable pin on display

	bcf     INFO,I_FLAG     ; Assume next send is SENDD
	return

;LCDWAIT:
;	clrf	TIME		; Clear time downcounter
;WAITLOOP:
;	nop			; Extend timerloop to 256
;	decfsz	TIME,F		; Decrement timer
;	goto	WAITLOOP	; and loop if not down to zero again
;	movwf	TIME		; W contains outer loop value
;	decfsz	TIME,W		; Decrement
;	goto	LCDWAIT
;	return

