function ccir(freq,N)

    freqs=[1981 1124 1197 1275 1358 1446 1540 1640 1747 1860 \
	   2400 930 2247 991 2110];

    Fs = 8000;
    power = zeros(length(freqs),1);
#    N = 288;
    
    t = linspace(0, 2*pi*N*(freq/Fs), N);
    data = sin(t);
    
    for J=1:length(freqs)
	k=round(N*freqs(J)/Fs);
	w=2*pi*k/N;
	coeff=2.0*cos(w);
	
	Q0=0;
	Q1=0;
	Q2=0;
	for I=1:N
	    Q2=Q1;
	    Q1=Q0;
	    Q0=coeff*Q1-Q2+data(I);
	endfor
	power(J) = (Q0**2) + (Q1**2) - (Q0*Q1*coeff);
	if (power(J) > 2800.0)
	    printf("%d %f\n", freqs(J), (Q0**2) + (Q1**2) - \
		   (Q0*Q1*coeff));
	endif
    endfor
endfunction
