;Node
(define nodes
  (list (cons (cons 0 0) 0)))

(define (nodify node)
  (let ((current (assoc node nodes)))
    (if current
	(cdr current)
	(begin
	  (set! nodes
		(cons 
		 (cons node 
		       (+ (cdar nodes) 1))
		 nodes))
	  (cdar nodes)))))

(define my-schematic
  (list (list 'net (cons 1200 1300) (cons 1400 1300) 1 ())
	(list 'net (cons 1400 1500) (cons 3400 2300) 4 ())
	(list 'net (cons 1800 1400) (cons 2400 8400) 8 ())))

(define (nodify-schematic schematic)
  (cond ((null? schematic)
	 '())
	((eq? (caar schematic) 'net)
	 (cons
	  (append
	   (list 'net
		 (cons (nodify (cadar schematic))
		       (nodify (caddar schematic))))
	   (cdddar schematic))
	  (nodify-schematic (cdr schematic))))
	(else
	 (append 
	  (list (car schematic))
	  (nodify-schematic (cdr schematic))))))

(define (extract-net schematic)
  (cond ((null? schematic)
	 '())
	((eq? (caar schematic) 'net)
	 (cons (cadar schematic)
	       (extract-net (cdr schematic))))
	(else
	 (extract-net (cdr schematic)))))

