/* Copyright (c) 2003, Stefan Petersen
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name of the author nor the names of any contributors
 *    may be used to endorse or promote products derived from this 
 *    software without specific prior written permission.
 *   
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * This file is part of ape, Another Packet Engine
 *
 * $Id: audio.c,v 1.1.1.1 2003/09/10 18:35:54 spe Exp $
 *
 */

#include <stdlib.h>
#include <stdio.h>

#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/soundcard.h>

#include <sys/types.h>
#include <sys/stat.h>

#include "audio.h"

int
audio_init(char *device, audio_setup_t *setup)
{
    int format;
    int v;

    if ((setup->channels != 1) && (setup->channels != 2)){
	fprintf(stderr, "Illegal number of channels %d.\n", setup->channels);
	return(-1);
    }
    
    if ((setup->fd = open(AUDIO_DEV, O_RDONLY)) == -1) {
	perror(AUDIO_DEV);
	return(-1);
    }
    
    /*
     * Check and set appropriate sampling format (unsigned 8-bit)
     */
    if (ioctl(setup->fd, SNDCTL_DSP_GETFMTS, &format) == -1) {
	perror("SNDCTL_DSP_GETFMTS");
	return(-1);
    }
    if (!(format & AFMT_U8)) {
	fprintf(stderr, "This soundcard doesn't seem to support 8-bit ");
	fprintf(stderr, "unsigned sampling. Aborting!\n");
	return(-1);
    }
    format = AFMT_U8;
    if (ioctl(setup->fd, SNDCTL_DSP_SETFMT, &format) == -1) {
	perror("SNDCTL_DSP_SETFMT");
	return(-1);
    }
    if (!(format & AFMT_U8)) {
	fprintf(stderr, "This soundcard doesn't seem to support 8-bit ");
	fprintf(stderr, "unsigned sampling. Aborting!\n");
	return(-1);
    }
    
    /* Mono */
    v = setup->channels;
    if (ioctl(setup->fd, SNDCTL_DSP_CHANNELS, &v) == -1) {
	perror("SNDCTL_DSP_CHANNELS");
	return(-1);
    }
    if (v != setup->channels) {
	fprintf(stderr, 
		"Trying to set illegal number of channels:%d(is %d)\n", 
		setup->channels, v);
	return(-1);
    }

    /* Samplerate */
    v = setup->speed;
    if (ioctl(setup->fd, SNDCTL_DSP_SPEED, &v) == -1) {
	perror("SNDCTL_DSP_SPEED");
	return(-1);
    }
    if (v != setup->speed) {
	fprintf(stderr, "Trying to set illegal samplerate:%d(is %d)\n", 
		setup->speed, v);
	return(-1);
    }

    if (ioctl(setup->fd, SNDCTL_DSP_GETBLKSIZE, &(setup->blk_size)) == -1) {
	perror("SNDCTL_DSP_GETBLKSIZE");
	return(-1);
    }

    return 0;
} /* init_audio */
