function [result]=Jacobi(x, psi,N1,N2);
% Calculates the Jacobian matrix according to
% Orchard et al formula 6.
% Returns the Jacobian matrix
% Written by Johan Skatt, Royal Institute of Technology 1997
% Usage: Jacobi(x,psi,N1,N2)

a1=x(:,1:N1);
a2=zeros(1,N2);
b2=x(:,N1+1:N1+N2);
b1=x(:,N1+N2+1:2*N1+N2);
C1=x(:,2*N1+N2+1);

M=20/log(10);
a=[a1 a2 a1];
b=[b1 b2 b1];
D=[];
for n=1:2*N1+N2+1
  D=[D; 1-2*exp(a).*cos(psi(n)-b)+exp(2*a)];
end

a=[a2 a1];
b=[b2 b1];
diffGb=[];
diffGa=[];
for n=1:2*N1+N2+1
  diffGa=[diffGa; M*exp(a1).*(exp(a1)-cos(psi(n)-b1))];
  diffGb=[diffGb; -M*exp(a).*sin(psi(n)-b)];
end
part1=[diffGa diffGb]./D;

result=[part1 ones(2*N1+N2+1,1)];
