	TITLE	"Temperature measurement with DS1820"
	LIST	P=PIC16C84, R=HEX
	INCLUDE	"PICREG.EQU"

; 16C84 Pin Assignment		  i/o
DSBIT	equ	4		;   o RB 4 Dallas "one-wire" pin

; 16C84 Ram register assignment
	cblock	0x0C
		TEMP_S		; Temporary storage for STATUS
		TEMP_W		; Temporary storage for W. Used by pop & push
		TMP0		; Three temporary storages used by DS1820
		TMP1		; routines. Awaiting better namnes.
		TMP2
		DSSIGN		; Sign byte from DS1820
		DSMAG		; Magnitude byte from DS1820. 2 compl.
		LSD		; Least sign. BCD after conv.
		MSD		; Most sign. BCD after conv.
	endc

	org	PIC84		; Reset vector
	goto	INIT		; Jump to initialization vector

	org	INTVEC		; Interrupt vector
	push			; Save registers
	call	INTMAIN		; Call main interrupt routine
	pop			; Restore registers
	retfie			; Return from interrupt and clear flag

	include	"display.inc"

BOOT_MSG1:
	DEFSTR	"Temp Mea"
BOOT_MSG2:
	DEFSTR	"surement"
STATUS1:
	DEFSTR	"Temperat"
STATUS2:
	DEFSTR	"ure "

INIT:
	clrf	PORTA		; Clear port A register
	clrf	PORTB		; Dito port B register
	bsf	STATUS,RP0	; Go into page 1
	bcf	OPTREG,RBPU	; Enable weak Pull-Up on PORTB
	movlw	b'11100000'	; Set display as output in the beginning
	movwf	TRISA		; Store in PORTA tristate register
	movlw	b'11100001'	; Display control and DS1820 bit as output 
	movwf	TRISB
	bcf	STATUS,RP0	; Go out of page 1

	BL_OFF			; Turn of backlighter
	LCDINIT
	LINE1
	PRTSTR	BOOT_MSG1
	LINE2
	PRTSTR	BOOT_MSG2

	movlw	0xFF
	call	LCDWAIT
	movlw	0xFF
	call	LCDWAIT
	movlw	0xFF
	call	LCDWAIT
	movlw	0xFF
	call	LCDWAIT

MAIN:	
MEASURE:
	call	NEWTEMP		; Make a new temperature measurement
	addlw	0x00		; Check if OK (OK=0x00, not OK=0x01)
	btfss	STATUS,Z	; Measurement OK => W=0 => Z=1
	goto	MEASURE		; Wait for OK Mesurement


	movf	DSSIGN,F	; Is temperature positive or negative?
	btfsc	STATUS,Z	; Positive => Zero => Z=1
	goto	POSITIVE	; Positive => no 2'nd compl conversion

	comf	DSMAG,F		; First compl
	movlw	d'1'		; 2'nd compl.		
	addwf	DSMAG,F

POSITIVE:
	rrf	DSMAG,W		; Rotate away the 1/2 degree bit
	andlw	0x7F		; Mask upper bit
	call	BINBCD		; Convert it from binary to BCD

	LINE1
	PRTSTR	STATUS1
	LINE2
	PRTSTR	STATUS2

	movlw	'+'		; Print out plus ot minus sign
	movf	DSSIGN,F	; Dependent on value in DSSIGN
	btfss	STATUS,Z	; Positive => Zero => Z=1
	movlw	'-'
	call	SENDD

	movf	MSD,W		; Print out temperature (Most sign)
	addlw	'0'		; Convert to ASCII number
	call	SENDD
	movf	LSD,W		; Print out temperature (Least sign)
	addlw	'0'		; Convert to ASCII number
	call	SENDD

	movlw	'd'		; Print out a degree sign
	call	SENDD
	goto	MAIN


	include	"ds1820.inc"

BINBCD:	
	clrf	MSD
	movwf	LSD
GTENTH:
	movlw	d'10'
	subwf	LSD,W
	btfss	STATUS,C
	goto	OVER
	movwf	LSD
	incf	MSD,F
	goto	GTENTH
OVER:	retlw	0

	

INTMAIN:
	return			; No IRQ routines

	end