
;(define sch-file 
;  (open-input-file 
;   "/usr/home/spe/lang/scheme/flipflop_1.sch"))

; (symbol? N) = #t
; (symbol? 7400-1.sym) = #t

(define (make-xy port)
  (cons (read port) (read port)))

(define (parse-schematic port)
  (do ((object (read port) (read port))
       (netlist '() ))
      ((eof-object? object) netlist)
    (set! netlist 
	  (append netlist 
		  (list (parse-line object port))))))

(define (parse-line object port)
  (case object
    ((N) (parse-net-line port))
    ((C) (parse-component-line port))
    ((T) (parse-text-line port))
    ((D) (parse-d-line port))
    (else '(error (1 . 2)))))

(define (parse-net-line port)
  (list 'net
	(make-xy port) ;start node
	(make-xy port) ;end node
	(read port)    ;color/style
	(extension port)
	))

(define (parse-component-line port)
  (list 'component
	(make-xy port)
	(read port)
	(read port)
	;(extension port)
	))

(define (parse-text-line port)
  (list 'text
	(make-xy port)
	(read port) ;Text 1
	(read port) ;Text 2
	(read port) ;Text 3
	(read port) ;Text 4
	(begin 
	  (read-char port)
	  (read-line port)) ;Name 
	))

(define (parse-d-line port)
  (list 'D
	(read port)
	))

(define (extension? port) ;, Should handle eof
  (let ((sneak (peek-char port)))
    (if (char-whitespace? sneak)
	(begin
	  (read-char port)
	  (extension? port))
	(eqv? sneak #\{ ))))
	   
(define (extension port)
  (if (extension? port)
      (begin 
	(read port)
	(define returned (parse-line (read port) port)) ;We want to return this! How?
	(read port)
	returned)
      '()))

(define (search-netlist netlist)
  (if (not (null? netlist))
      (begin
	(display (caar netlist))
	(newline)
	(search-netlist (cdr netlist)))))