; An experiment with extracting net information from gschem
; schematics.

; Use it at your own risk
; Stefan Petersen (spe@stacken.kth.se)


(load "fileh.scm")
(load "node.scm")
(load "adjlist.scm")


; File with schematics
(define sch-file
  (open-input-file 
   "/usr/home/spe/lang/scheme/netlist-generation/flipflop_1.sch"))


;fileh.scm
; Converts the textual format in the schematic file to a
; list which scheme handles better.
; For an example of netlist, look in "netlist.scm".
(define parsed-schematic (parse-schematic sch-file))


;node.scm
; Nodify (enumarate) all X-Y pairs. All nodes gets an unique number.
(define nodified-schematic (nodify-schematic parsed-schematic))

; extract all pairs which describes between which two nodes a certain
; segment is connected.
(define seg-pairs (extract-net nodified-schematic))


;adjlist.scm
; From the list of segments, build a list which is used by the
; next algorithm (special form of a list).
(define adjlist (insert-seg-list seg-pairs))

; This is the algoritm which calculates which nodes are connected.
; It returns a list with lists, in which each list describes nodes
; that are connected.
(define connected-nodes  (traverse-adjlist adjlist))


(display connected-nodes)
(newline)
(exit)
