/* Copyright (c) 2004, Stefan Petersen
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name of the author nor the names of any contributors
 *    may be used to endorse or promote products derived from this 
 *    software without specific prior written permission.
 *   
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * This file is part of dsptest
 *
 * $Id: dsptest.c,v 1.1 2004/01/23 20:11:59 spe Exp $
 *
 */

#include <stdlib.h>
#include <stdio.h>

#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/soundcard.h>

#include <sys/types.h>
#include <sys/stat.h>

#define AUDIO_DEV "/dev/dsp"


const int samplingspeeds[] = {10800, 11025, 38400};

int
audio_test(char *device)
{
    int format;
    int fd, v, i;
    
    if ((fd = open(AUDIO_DEV, O_RDONLY)) == -1) {
	perror(AUDIO_DEV);
	return(-1);
    }
    
    /*
     * Check sampling format
     */
    if (ioctl(fd, SNDCTL_DSP_GETFMTS, &format) == -1) {
	perror("SNDCTL_DSP_GETFMTS");
	return(-1);
    }
    printf("The following sampling format can your soundcard return:\n");
    if (format & AFMT_U8)
	printf(" 8-bit unsigned\n");
    if (format & AFMT_S16_LE)
	printf(" 16-bit signed little endian\n");
    if (format & AFMT_S16_BE)
	printf(" 16-bit signed big endian\n");
    if (format & AFMT_S16_NE)
	printf(" 16-bit signed native endian\n");
    if (format & AFMT_S8)
	printf(" 8-bit signed\n");
    if (format & AFMT_U16_LE)
	printf(" 16-bit unsigned little endian\n");
    if (format & AFMT_U16_BE)
	printf(" 16-bit unsigned big endian\n");

    
    /* Testing channels */
    printf("Channels:\n");

    v = 1;
    if (ioctl(fd, SNDCTL_DSP_CHANNELS, &v) == -1) {
	perror("SNDCTL_DSP_CHANNELS");
	return(-1);
    }
    if (v != 1) {
	printf(" Mono failed\n");
    } else {
	printf(" Mono worked\n");
    }

    v = 2;
    if (ioctl(fd, SNDCTL_DSP_CHANNELS, &v) == -1) {
	perror("SNDCTL_DSP_CHANNELS");
	return(-1);
    }
    if (v != 2) {
	printf(" Stereo failed\n");
    } else {
	printf(" Stereo worked\n");
    }

    /* Samplerate */
    printf("Operation of the following sampling speeds:\n");
    for (i = 0; i < sizeof(samplingspeeds)/sizeof(samplingspeeds[0]); i++) {
	printf(" %d ", samplingspeeds[i]);

	v = samplingspeeds[i];
	if (ioctl(fd, SNDCTL_DSP_SPEED, &v) == -1) {
	    perror("SNDCTL_DSP_SPEED");
	    return(-1);
	}

	if (v != samplingspeeds[i]) {
	    printf("failed\n");
	} else {
	    printf("worked\n");
	}
    }

    close(fd);

    return 0;
} /* audio_test */


int
main(int argc, char * argv[])
{
    audio_test(AUDIO_DEV);

    return 0;
}
