function [result]=G(x, psi, N1, N2);
% Calculates the powerpattern function G according to
% Orchard et al formula 5. Returns a vector containing 
% the value of G at the given psi angle(s).
% Written by Johan Skatt & Stefan Petersen
% Royal Institute of Technology 1997
% Usage: G(x,psi,N1,N2)

a1=x(:,1:N1);
a2=zeros(1,N2);
b2=x(:,N1+1:2*N1);
b1=x(:,2*N1+1:2*N1+N2);
C1=x(:,2*N1+N2+1);

a=[a2 a1];
b=[b2 b1];

result=[];
for n=1:length(psi)
  part1=10.*log10(1-2*exp(a).*cos(psi(n)-b)+exp(2*a));
  part2=10*log10(2*(1+cos(psi(n))))+C1;
  result=[result sum(part1)+part2];
end
