	TITLE   "Program to test LCD drive macros"
	LIST    P=PIC16C84, R=HEX
	INCLUDE "PICREG.EQU"


TEMP_W	equ	0Dh		; Temporary W Save Address
TEMP_S	equ	0Eh		; Temporary STATUS Save Address

	org     PIC84           ; Reset vector
	goto    INIT            ; Jump to initialization routine

	org     INTVEC          ; Interrupt vector
RESET_GIE:
	bcf	INTCON,GIE
	btfsc	INTCON,GIE
	goto	RESET_GIE

	push                    ; Save registers
	call    INTMAIN         ; Call main interrupt routine
	pop                     ; Restore registers
	retfie                  ; Return from interrupt and clear flag

	include "display.inc"

STARTMSG:
	DEFSTR	"Hello"
MSG2:
	DEFSTR	"Again"

INIT:
	clrf    RTCC            ; Clear RTCC
	movlw   b'10100000'     ; Set interrupt = ON, RT = ON, INT = ON
	movwf   INTCON          ; Store in INTCON register
	clrf    PORTA           ; Clear port A register
	clrf    PORTB           ; Clear port B register
	bsf     STATUS,RP0      ; Must be in page 1 to access OPTION register
	movlw   b'11010001'     ; Set RTCC to osc/4 & 1:4 presc, rising edge
	movwf   OPTREG          ; Store in OPTION register
	movlw   b'10000011'     ; Set PORTB Tristate Latches
	movwf   TRISB           ; Store in PORTB tristate register
	bcf     STATUS,RP0      ; Back to page 0

	LCDINIT
	bsf	PORTA,4		; Hopefully turn of the light
MAIN:
	PRTSTR	STARTMSG
	LINE2
	PRTSTR	MSG2

ETERNAL:
	goto	ETERNAL


; INTERRUPT ROUTINE
INTMAIN:
	btfss   INTCON,RTIF     ; Check if RTCC interrupt
	return			; If it wasn't from RTCC, don't care
	bcf	INTCON,RTIF
	decf	TIME,F
	return

WAIT:
	movwf	TIME
WAITLOOP:
	movf	TIME,W
	btfsc	STATUS,Z
	return
	goto	WAITLOOP

	end
