function [result]=calcI(x,N1,N2) 
% Returns excitation I of all elements in complex form.
% Written by Johan Skatt & Stefan Petersen
% Royal Institute of Technology 1997
% Usage: calcI(x,N1,N2)

a1=x(:,1:N1);
a2=zeros(1,N2);
b2=x(:,N1+1:N1+N2);
b1=x(:,N1+N2+1:2*N1+N2);
C1=x(:,2*N1+N2+1);
a=[a2 a1];
b=[b2 b1];

result=poly(exp(a+i*b));
