%% Generated by the Erlang ASN.1 BER-compiler version:1.4
%% Purpose: encoder and decoder to the types in mod LDAPv3

-module('LDAPv3').
-include("LDAPv3.hrl").
-define('RT_BER',asn1rt_ber_bin).
-export([encoding_rule/0]).
-export([
'enc_LDAPMessage'/2,
'enc_MessageID'/2,
'enc_LDAPString'/2,
'enc_LDAPOID'/2,
'enc_LDAPDN'/2,
'enc_RelativeLDAPDN'/2,
'enc_AttributeType'/2,
'enc_AttributeDescription'/2,
'enc_AttributeDescriptionList'/2,
'enc_AttributeValue'/2,
'enc_AttributeValueAssertion'/2,
'enc_AssertionValue'/2,
'enc_Attribute'/2,
'enc_MatchingRuleId'/2,
'enc_LDAPResult'/2,
'enc_Referral'/2,
'enc_LDAPURL'/2,
'enc_Controls'/2,
'enc_Control'/2,
'enc_BindRequest'/2,
'enc_AuthenticationChoice'/2,
'enc_SaslCredentials'/2,
'enc_BindResponse'/2,
'enc_UnbindRequest'/2,
'enc_SearchRequest'/2,
'enc_Filter'/2,
'enc_SubstringFilter'/2,
'enc_MatchingRuleAssertion'/2,
'enc_SearchResultEntry'/2,
'enc_PartialAttributeList'/2,
'enc_SearchResultReference'/2,
'enc_SearchResultDone'/2,
'enc_ModifyRequest'/2,
'enc_AttributeTypeAndValues'/2,
'enc_ModifyResponse'/2,
'enc_AddRequest'/2,
'enc_AttributeList'/2,
'enc_AddResponse'/2,
'enc_DelRequest'/2,
'enc_DelResponse'/2,
'enc_ModifyDNRequest'/2,
'enc_ModifyDNResponse'/2,
'enc_CompareRequest'/2,
'enc_CompareResponse'/2,
'enc_AbandonRequest'/2,
'enc_ExtendedRequest'/2,
'enc_ExtendedResponse'/2
]).

-export([
'dec_LDAPMessage'/2,
'dec_MessageID'/2,
'dec_LDAPString'/2,
'dec_LDAPOID'/2,
'dec_LDAPDN'/2,
'dec_RelativeLDAPDN'/2,
'dec_AttributeType'/2,
'dec_AttributeDescription'/2,
'dec_AttributeDescriptionList'/2,
'dec_AttributeValue'/2,
'dec_AttributeValueAssertion'/2,
'dec_AssertionValue'/2,
'dec_Attribute'/2,
'dec_MatchingRuleId'/2,
'dec_LDAPResult'/2,
'dec_Referral'/2,
'dec_LDAPURL'/2,
'dec_Controls'/2,
'dec_Control'/2,
'dec_BindRequest'/2,
'dec_AuthenticationChoice'/2,
'dec_SaslCredentials'/2,
'dec_BindResponse'/2,
'dec_UnbindRequest'/2,
'dec_SearchRequest'/2,
'dec_Filter'/2,
'dec_SubstringFilter'/2,
'dec_MatchingRuleAssertion'/2,
'dec_SearchResultEntry'/2,
'dec_PartialAttributeList'/2,
'dec_SearchResultReference'/2,
'dec_SearchResultDone'/2,
'dec_ModifyRequest'/2,
'dec_AttributeTypeAndValues'/2,
'dec_ModifyResponse'/2,
'dec_AddRequest'/2,
'dec_AttributeList'/2,
'dec_AddResponse'/2,
'dec_DelRequest'/2,
'dec_DelResponse'/2,
'dec_ModifyDNRequest'/2,
'dec_ModifyDNResponse'/2,
'dec_CompareRequest'/2,
'dec_CompareResponse'/2,
'dec_AbandonRequest'/2,
'dec_ExtendedRequest'/2,
'dec_ExtendedResponse'/2
]).

-export([
'dec_LDAPMessage'/3,
'dec_MessageID'/3,
'dec_LDAPString'/3,
'dec_LDAPOID'/3,
'dec_LDAPDN'/3,
'dec_RelativeLDAPDN'/3,
'dec_AttributeType'/3,
'dec_AttributeDescription'/3,
'dec_AttributeDescriptionList'/3,
'dec_AttributeValue'/3,
'dec_AttributeValueAssertion'/3,
'dec_AssertionValue'/3,
'dec_Attribute'/3,
'dec_MatchingRuleId'/3,
'dec_LDAPResult'/3,
'dec_Referral'/3,
'dec_LDAPURL'/3,
'dec_Controls'/3,
'dec_Control'/3,
'dec_BindRequest'/3,
'dec_AuthenticationChoice'/3,
'dec_SaslCredentials'/3,
'dec_BindResponse'/3,
'dec_UnbindRequest'/3,
'dec_SearchRequest'/3,
'dec_Filter'/3,
'dec_SubstringFilter'/3,
'dec_MatchingRuleAssertion'/3,
'dec_SearchResultEntry'/3,
'dec_PartialAttributeList'/3,
'dec_SearchResultReference'/3,
'dec_SearchResultDone'/3,
'dec_ModifyRequest'/3,
'dec_AttributeTypeAndValues'/3,
'dec_ModifyResponse'/3,
'dec_AddRequest'/3,
'dec_AttributeList'/3,
'dec_AddResponse'/3,
'dec_DelRequest'/3,
'dec_DelResponse'/3,
'dec_ModifyDNRequest'/3,
'dec_ModifyDNResponse'/3,
'dec_CompareRequest'/3,
'dec_CompareResponse'/3,
'dec_AbandonRequest'/3,
'dec_ExtendedRequest'/3,
'dec_ExtendedResponse'/3
]).

-export([
'maxInt'/0
]).

-export([info/0]).


-export([encode/2,decode/2,encode_disp/2,decode_disp/2]).

encoding_rule() ->
   ber.

encode(Type,Data) ->
case catch encode_disp(Type,Data) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  {Bytes,_Len} ->
    {ok,wrap_encode(Bytes)};
  Bytes ->
    {ok,wrap_encode(Bytes)}
end.

decode(Type,Data) ->
case catch decode_disp(Type,wrap_decode(Data)) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  {X,_Rest} ->
    {ok,X};
  {X,_Rest,_Len} ->
    {ok,X}
end.

encode_disp('LDAPMessage',Data) -> 'enc_LDAPMessage'(Data,[]);
encode_disp('MessageID',Data) -> 'enc_MessageID'(Data,[]);
encode_disp('LDAPString',Data) -> 'enc_LDAPString'(Data,[]);
encode_disp('LDAPOID',Data) -> 'enc_LDAPOID'(Data,[]);
encode_disp('LDAPDN',Data) -> 'enc_LDAPDN'(Data,[]);
encode_disp('RelativeLDAPDN',Data) -> 'enc_RelativeLDAPDN'(Data,[]);
encode_disp('AttributeType',Data) -> 'enc_AttributeType'(Data,[]);
encode_disp('AttributeDescription',Data) -> 'enc_AttributeDescription'(Data,[]);
encode_disp('AttributeDescriptionList',Data) -> 'enc_AttributeDescriptionList'(Data,[]);
encode_disp('AttributeValue',Data) -> 'enc_AttributeValue'(Data,[]);
encode_disp('AttributeValueAssertion',Data) -> 'enc_AttributeValueAssertion'(Data,[]);
encode_disp('AssertionValue',Data) -> 'enc_AssertionValue'(Data,[]);
encode_disp('Attribute',Data) -> 'enc_Attribute'(Data,[]);
encode_disp('MatchingRuleId',Data) -> 'enc_MatchingRuleId'(Data,[]);
encode_disp('LDAPResult',Data) -> 'enc_LDAPResult'(Data,[]);
encode_disp('Referral',Data) -> 'enc_Referral'(Data,[]);
encode_disp('LDAPURL',Data) -> 'enc_LDAPURL'(Data,[]);
encode_disp('Controls',Data) -> 'enc_Controls'(Data,[]);
encode_disp('Control',Data) -> 'enc_Control'(Data,[]);
encode_disp('BindRequest',Data) -> 'enc_BindRequest'(Data,[]);
encode_disp('AuthenticationChoice',Data) -> 'enc_AuthenticationChoice'(Data,[]);
encode_disp('SaslCredentials',Data) -> 'enc_SaslCredentials'(Data,[]);
encode_disp('BindResponse',Data) -> 'enc_BindResponse'(Data,[]);
encode_disp('UnbindRequest',Data) -> 'enc_UnbindRequest'(Data,[]);
encode_disp('SearchRequest',Data) -> 'enc_SearchRequest'(Data,[]);
encode_disp('Filter',Data) -> 'enc_Filter'(Data,[]);
encode_disp('SubstringFilter',Data) -> 'enc_SubstringFilter'(Data,[]);
encode_disp('MatchingRuleAssertion',Data) -> 'enc_MatchingRuleAssertion'(Data,[]);
encode_disp('SearchResultEntry',Data) -> 'enc_SearchResultEntry'(Data,[]);
encode_disp('PartialAttributeList',Data) -> 'enc_PartialAttributeList'(Data,[]);
encode_disp('SearchResultReference',Data) -> 'enc_SearchResultReference'(Data,[]);
encode_disp('SearchResultDone',Data) -> 'enc_SearchResultDone'(Data,[]);
encode_disp('ModifyRequest',Data) -> 'enc_ModifyRequest'(Data,[]);
encode_disp('AttributeTypeAndValues',Data) -> 'enc_AttributeTypeAndValues'(Data,[]);
encode_disp('ModifyResponse',Data) -> 'enc_ModifyResponse'(Data,[]);
encode_disp('AddRequest',Data) -> 'enc_AddRequest'(Data,[]);
encode_disp('AttributeList',Data) -> 'enc_AttributeList'(Data,[]);
encode_disp('AddResponse',Data) -> 'enc_AddResponse'(Data,[]);
encode_disp('DelRequest',Data) -> 'enc_DelRequest'(Data,[]);
encode_disp('DelResponse',Data) -> 'enc_DelResponse'(Data,[]);
encode_disp('ModifyDNRequest',Data) -> 'enc_ModifyDNRequest'(Data,[]);
encode_disp('ModifyDNResponse',Data) -> 'enc_ModifyDNResponse'(Data,[]);
encode_disp('CompareRequest',Data) -> 'enc_CompareRequest'(Data,[]);
encode_disp('CompareResponse',Data) -> 'enc_CompareResponse'(Data,[]);
encode_disp('AbandonRequest',Data) -> 'enc_AbandonRequest'(Data,[]);
encode_disp('ExtendedRequest',Data) -> 'enc_ExtendedRequest'(Data,[]);
encode_disp('ExtendedResponse',Data) -> 'enc_ExtendedResponse'(Data,[]);
encode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).


decode_disp('LDAPMessage',Data) -> 'dec_LDAPMessage'(Data,mandatory);
decode_disp('MessageID',Data) -> 'dec_MessageID'(Data,mandatory);
decode_disp('LDAPString',Data) -> 'dec_LDAPString'(Data,mandatory);
decode_disp('LDAPOID',Data) -> 'dec_LDAPOID'(Data,mandatory);
decode_disp('LDAPDN',Data) -> 'dec_LDAPDN'(Data,mandatory);
decode_disp('RelativeLDAPDN',Data) -> 'dec_RelativeLDAPDN'(Data,mandatory);
decode_disp('AttributeType',Data) -> 'dec_AttributeType'(Data,mandatory);
decode_disp('AttributeDescription',Data) -> 'dec_AttributeDescription'(Data,mandatory);
decode_disp('AttributeDescriptionList',Data) -> 'dec_AttributeDescriptionList'(Data,mandatory);
decode_disp('AttributeValue',Data) -> 'dec_AttributeValue'(Data,mandatory);
decode_disp('AttributeValueAssertion',Data) -> 'dec_AttributeValueAssertion'(Data,mandatory);
decode_disp('AssertionValue',Data) -> 'dec_AssertionValue'(Data,mandatory);
decode_disp('Attribute',Data) -> 'dec_Attribute'(Data,mandatory);
decode_disp('MatchingRuleId',Data) -> 'dec_MatchingRuleId'(Data,mandatory);
decode_disp('LDAPResult',Data) -> 'dec_LDAPResult'(Data,mandatory);
decode_disp('Referral',Data) -> 'dec_Referral'(Data,mandatory);
decode_disp('LDAPURL',Data) -> 'dec_LDAPURL'(Data,mandatory);
decode_disp('Controls',Data) -> 'dec_Controls'(Data,mandatory);
decode_disp('Control',Data) -> 'dec_Control'(Data,mandatory);
decode_disp('BindRequest',Data) -> 'dec_BindRequest'(Data,mandatory);
decode_disp('AuthenticationChoice',Data) -> 'dec_AuthenticationChoice'(Data,mandatory);
decode_disp('SaslCredentials',Data) -> 'dec_SaslCredentials'(Data,mandatory);
decode_disp('BindResponse',Data) -> 'dec_BindResponse'(Data,mandatory);
decode_disp('UnbindRequest',Data) -> 'dec_UnbindRequest'(Data,mandatory);
decode_disp('SearchRequest',Data) -> 'dec_SearchRequest'(Data,mandatory);
decode_disp('Filter',Data) -> 'dec_Filter'(Data,mandatory);
decode_disp('SubstringFilter',Data) -> 'dec_SubstringFilter'(Data,mandatory);
decode_disp('MatchingRuleAssertion',Data) -> 'dec_MatchingRuleAssertion'(Data,mandatory);
decode_disp('SearchResultEntry',Data) -> 'dec_SearchResultEntry'(Data,mandatory);
decode_disp('PartialAttributeList',Data) -> 'dec_PartialAttributeList'(Data,mandatory);
decode_disp('SearchResultReference',Data) -> 'dec_SearchResultReference'(Data,mandatory);
decode_disp('SearchResultDone',Data) -> 'dec_SearchResultDone'(Data,mandatory);
decode_disp('ModifyRequest',Data) -> 'dec_ModifyRequest'(Data,mandatory);
decode_disp('AttributeTypeAndValues',Data) -> 'dec_AttributeTypeAndValues'(Data,mandatory);
decode_disp('ModifyResponse',Data) -> 'dec_ModifyResponse'(Data,mandatory);
decode_disp('AddRequest',Data) -> 'dec_AddRequest'(Data,mandatory);
decode_disp('AttributeList',Data) -> 'dec_AttributeList'(Data,mandatory);
decode_disp('AddResponse',Data) -> 'dec_AddResponse'(Data,mandatory);
decode_disp('DelRequest',Data) -> 'dec_DelRequest'(Data,mandatory);
decode_disp('DelResponse',Data) -> 'dec_DelResponse'(Data,mandatory);
decode_disp('ModifyDNRequest',Data) -> 'dec_ModifyDNRequest'(Data,mandatory);
decode_disp('ModifyDNResponse',Data) -> 'dec_ModifyDNResponse'(Data,mandatory);
decode_disp('CompareRequest',Data) -> 'dec_CompareRequest'(Data,mandatory);
decode_disp('CompareResponse',Data) -> 'dec_CompareResponse'(Data,mandatory);
decode_disp('AbandonRequest',Data) -> 'dec_AbandonRequest'(Data,mandatory);
decode_disp('ExtendedRequest',Data) -> 'dec_ExtendedRequest'(Data,mandatory);
decode_disp('ExtendedResponse',Data) -> 'dec_ExtendedResponse'(Data,mandatory);
decode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).



wrap_encode(Bytes) when list(Bytes) ->
   binary_to_list(list_to_binary(Bytes));
wrap_encode(Bytes) when binary(Bytes) ->
   binary_to_list(Bytes);
wrap_encode(Bytes) -> Bytes.

wrap_decode(Bytes) when list(Bytes) ->
   list_to_binary(Bytes);
wrap_decode(Bytes) -> Bytes.


info() ->
  [{vsn,'1.4'},   {module,'LDAPv3'},   {options,[]}].


%%================================
%%  LDAPMessage
%%================================
'enc_LDAPMessage'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_integer([], ?RT_BER:cindex(2,Val,messageID), []),

%%-------------------------------------------------
%% attribute number 2 with type CHOICE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_LDAPMessage_protocolOp'(?RT_BER:cindex(3,Val,protocolOp), []),

%%-------------------------------------------------
%% attribute number 3   External LDAPv3:Controls OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case ?RT_BER:cindex(4,Val,controls) of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Controls'(?RT_BER:cindex(4,Val,controls), [{tag,128,0,'IMPLICIT',32}])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).



%%================================
%%  LDAPMessage_protocolOp
%%================================

'enc_LDAPMessage_protocolOp'({'LDAPMessage_protocolOp',Val}, TagIn) ->
   'enc_LDAPMessage_protocolOp'(Val, TagIn);

'enc_LDAPMessage_protocolOp'(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      bindRequest ->
         'enc_BindRequest'(element(2,Val), []);
      bindResponse ->
         'enc_BindResponse'(element(2,Val), []);
      unbindRequest ->
         ?RT_BER:encode_null(element(2,Val), [{tag,64,2,'IMPLICIT',32}]);
      searchRequest ->
         'enc_SearchRequest'(element(2,Val), []);
      searchResEntry ->
         'enc_SearchResultEntry'(element(2,Val), []);
      searchResDone ->
         'enc_SearchResultDone'(element(2,Val), []);
      searchResRef ->
         'enc_SearchResultReference'(element(2,Val), []);
      modifyRequest ->
         'enc_ModifyRequest'(element(2,Val), []);
      modifyResponse ->
         'enc_ModifyResponse'(element(2,Val), []);
      addRequest ->
         'enc_AddRequest'(element(2,Val), []);
      addResponse ->
         'enc_AddResponse'(element(2,Val), []);
      delRequest ->
         ?RT_BER:encode_octet_string([], element(2,Val), [{tag,64,10,'IMPLICIT',32}]);
      delResponse ->
         'enc_DelResponse'(element(2,Val), []);
      modDNRequest ->
         'enc_ModifyDNRequest'(element(2,Val), []);
      modDNResponse ->
         'enc_ModifyDNResponse'(element(2,Val), []);
      compareRequest ->
         'enc_CompareRequest'(element(2,Val), []);
      compareResponse ->
         'enc_CompareResponse'(element(2,Val), []);
      abandonRequest ->
         ?RT_BER:encode_integer([], element(2,Val), [{tag,64,16,'IMPLICIT',32}]);
      extendedReq ->
         'enc_ExtendedRequest'(element(2,Val), []);
      extendedResp ->
         'enc_ExtendedResponse'(element(2,Val), []);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn ++[], EncBytes, EncLen).


'dec_LDAPMessage_protocolOp'(Bytes, OptOrMand, TagIn) ->
   {{_,Len},Bytes1, RbExp} = ?RT_BER:check_tags(TagIn++[], Bytes, OptOrMand),
   IndefEndBytes = fun(indefinite,<<0,0,R/binary>>)-> R; (_,B)-> B end,
   IndefEndRb = fun(indefinite,<<0,0,R/binary>>)-> 2; (_,_)-> 0 end,
   case Bytes1 of

%% 'bindRequest'
      <<1:2,_:1,0:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_BindRequest'(Bytes1, mandatory, []),
         {{bindRequest, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'bindResponse'
      <<1:2,_:1,1:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_BindResponse'(Bytes1, mandatory, []),
         {{bindResponse, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'unbindRequest'
      <<1:2,_:1,2:5,_/binary>> ->
         {Dec, Rest, RbCho} = ?RT_BER:decode_null(Bytes1,[{tag,64,2,'IMPLICIT',32}], mandatory),
         {{unbindRequest, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'searchRequest'
      <<1:2,_:1,3:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_SearchRequest'(Bytes1, mandatory, []),
         {{searchRequest, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'searchResEntry'
      <<1:2,_:1,4:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_SearchResultEntry'(Bytes1, mandatory, []),
         {{searchResEntry, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'searchResDone'
      <<1:2,_:1,5:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_SearchResultDone'(Bytes1, mandatory, []),
         {{searchResDone, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'searchResRef'
      <<1:2,_:1,19:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_SearchResultReference'(Bytes1, mandatory, []),
         {{searchResRef, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'modifyRequest'
      <<1:2,_:1,6:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_ModifyRequest'(Bytes1, mandatory, []),
         {{modifyRequest, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'modifyResponse'
      <<1:2,_:1,7:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_ModifyResponse'(Bytes1, mandatory, []),
         {{modifyResponse, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'addRequest'
      <<1:2,_:1,8:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_AddRequest'(Bytes1, mandatory, []),
         {{addRequest, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'addResponse'
      <<1:2,_:1,9:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_AddResponse'(Bytes1, mandatory, []),
         {{addResponse, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'delRequest'
      <<1:2,_:1,10:5,_/binary>> ->
         {Dec, Rest, RbCho} = ?RT_BER:decode_octet_string(Bytes1,[],[{tag,64,10,'IMPLICIT',32}], no_length, mandatory),
         {{delRequest, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'delResponse'
      <<1:2,_:1,11:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_DelResponse'(Bytes1, mandatory, []),
         {{delResponse, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'modDNRequest'
      <<1:2,_:1,12:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_ModifyDNRequest'(Bytes1, mandatory, []),
         {{modDNRequest, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'modDNResponse'
      <<1:2,_:1,13:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_ModifyDNResponse'(Bytes1, mandatory, []),
         {{modDNResponse, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'compareRequest'
      <<1:2,_:1,14:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_CompareRequest'(Bytes1, mandatory, []),
         {{compareRequest, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'compareResponse'
      <<1:2,_:1,15:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_CompareResponse'(Bytes1, mandatory, []),
         {{compareResponse, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'abandonRequest'
      <<1:2,_:1,16:5,_/binary>> ->
         {Dec, Rest, RbCho} = ?RT_BER:decode_integer(Bytes1,{0,2147483647},[{tag,64,16,'IMPLICIT',32}], mandatory),
         {{abandonRequest, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'extendedReq'
      <<1:2,_:1,23:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_ExtendedRequest'(Bytes1, mandatory, []),
         {{extendedReq, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'extendedResp'
      <<1:2,_:1,24:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_ExtendedResponse'(Bytes1, mandatory, []),
         {{extendedResp, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};

      Else -> 
         case OptOrMand of
            mandatory ->exit({error,{asn1,{invalid_choice_tag,Else}}});
            _ ->exit({error,{asn1,{no_optional_tag,Else}}})
         end
   end.


'dec_LDAPMessage'(Bytes, OptOrMand) ->
   'dec_LDAPMessage'(Bytes, OptOrMand, []).

'dec_LDAPMessage'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type INTEGER
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_integer(Bytes2,{0,2147483647},[], mandatory),

%%-------------------------------------------------
%% attribute number 2 with type CHOICE
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = 'dec_LDAPMessage_protocolOp'(Bytes3, mandatory, []),

%%-------------------------------------------------
%% attribute number 3   External LDAPv3:Controls OPTIONAL
%%-------------------------------------------------
   {Term3,Bytes5,Rb4} = case Bytes4 of
<<2:2,_:1,0:5,_/binary>> ->
'dec_Controls'(Bytes4, opt_or_default, [{tag,128,0,'IMPLICIT',32}]);
_ ->
{ asn1_NOVALUE, Bytes4, 0 }
end,

   {Bytes6,Rb5} = ?RT_BER:restbytes2(RemBytes, Bytes5,noext),
   {{'LDAPMessage', Term1, Term2, Term3}, Bytes6, Rb1+Rb2+Rb3+Rb4+Rb5}.


%%================================
%%  MessageID
%%================================

'enc_MessageID'({'MessageID',Val}, TagIn) ->
   'enc_MessageID'(Val, TagIn);

'enc_MessageID'(Val, TagIn) ->
?RT_BER:encode_integer([], Val, TagIn ++ []).


'dec_MessageID'(Bytes, OptOrMand) ->
   'dec_MessageID'(Bytes, OptOrMand, []).

'dec_MessageID'(Bytes, OptOrMand, TagIn) ->
?RT_BER:decode_integer(Bytes,{0,2147483647},TagIn++[], OptOrMand).



%%================================
%%  LDAPString
%%================================

'enc_LDAPString'({'LDAPString',Val}, TagIn) ->
   'enc_LDAPString'(Val, TagIn);

'enc_LDAPString'(Val, TagIn) ->
?RT_BER:encode_octet_string([], Val, TagIn ++ []).


'dec_LDAPString'(Bytes, OptOrMand) ->
   'dec_LDAPString'(Bytes, OptOrMand, []).

'dec_LDAPString'(Bytes, OptOrMand, TagIn) ->
?RT_BER:decode_octet_string(Bytes,[],TagIn++[], no_length, OptOrMand).



%%================================
%%  LDAPOID
%%================================

'enc_LDAPOID'({'LDAPOID',Val}, TagIn) ->
   'enc_LDAPOID'(Val, TagIn);

'enc_LDAPOID'(Val, TagIn) ->
?RT_BER:encode_octet_string([], Val, TagIn ++ []).


'dec_LDAPOID'(Bytes, OptOrMand) ->
   'dec_LDAPOID'(Bytes, OptOrMand, []).

'dec_LDAPOID'(Bytes, OptOrMand, TagIn) ->
?RT_BER:decode_octet_string(Bytes,[],TagIn++[], no_length, OptOrMand).



%%================================
%%  LDAPDN
%%================================

'enc_LDAPDN'({'LDAPDN',Val}, TagIn) ->
   'enc_LDAPDN'(Val, TagIn);

'enc_LDAPDN'(Val, TagIn) ->
?RT_BER:encode_octet_string([], Val, TagIn ++ []).


'dec_LDAPDN'(Bytes, OptOrMand) ->
   'dec_LDAPDN'(Bytes, OptOrMand, []).

'dec_LDAPDN'(Bytes, OptOrMand, TagIn) ->
?RT_BER:decode_octet_string(Bytes,[],TagIn++[], no_length, OptOrMand).



%%================================
%%  RelativeLDAPDN
%%================================

'enc_RelativeLDAPDN'({'RelativeLDAPDN',Val}, TagIn) ->
   'enc_RelativeLDAPDN'(Val, TagIn);

'enc_RelativeLDAPDN'(Val, TagIn) ->
?RT_BER:encode_octet_string([], Val, TagIn ++ []).


'dec_RelativeLDAPDN'(Bytes, OptOrMand) ->
   'dec_RelativeLDAPDN'(Bytes, OptOrMand, []).

'dec_RelativeLDAPDN'(Bytes, OptOrMand, TagIn) ->
?RT_BER:decode_octet_string(Bytes,[],TagIn++[], no_length, OptOrMand).



%%================================
%%  AttributeType
%%================================

'enc_AttributeType'({'AttributeType',Val}, TagIn) ->
   'enc_AttributeType'(Val, TagIn);

'enc_AttributeType'(Val, TagIn) ->
?RT_BER:encode_octet_string([], Val, TagIn ++ []).


'dec_AttributeType'(Bytes, OptOrMand) ->
   'dec_AttributeType'(Bytes, OptOrMand, []).

'dec_AttributeType'(Bytes, OptOrMand, TagIn) ->
?RT_BER:decode_octet_string(Bytes,[],TagIn++[], no_length, OptOrMand).



%%================================
%%  AttributeDescription
%%================================

'enc_AttributeDescription'({'AttributeDescription',Val}, TagIn) ->
   'enc_AttributeDescription'(Val, TagIn);

'enc_AttributeDescription'(Val, TagIn) ->
?RT_BER:encode_octet_string([], Val, TagIn ++ []).


'dec_AttributeDescription'(Bytes, OptOrMand) ->
   'dec_AttributeDescription'(Bytes, OptOrMand, []).

'dec_AttributeDescription'(Bytes, OptOrMand, TagIn) ->
?RT_BER:decode_octet_string(Bytes,[],TagIn++[], no_length, OptOrMand).



%%================================
%%  AttributeDescriptionList
%%================================

'enc_AttributeDescriptionList'({'AttributeDescriptionList',Val}, TagIn) ->
   'enc_AttributeDescriptionList'(Val, TagIn);

'enc_AttributeDescriptionList'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_AttributeDescriptionList_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], EncBytes, EncLen).

'enc_AttributeDescriptionList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttributeDescriptionList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = ?RT_BER:encode_octet_string([], H, []),
   'enc_AttributeDescriptionList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_AttributeDescriptionList'(Bytes, OptOrMand) ->
   'dec_AttributeDescriptionList'(Bytes, OptOrMand, []).

'dec_AttributeDescriptionList'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
   ?RT_BER:decode_components(Rb1, Len, Bytes1, fun(FBytes,_,_)->
?RT_BER:decode_octet_string(FBytes,[],[], no_length, mandatory)
end, [], []).




%%================================
%%  AttributeValue
%%================================

'enc_AttributeValue'({'AttributeValue',Val}, TagIn) ->
   'enc_AttributeValue'(Val, TagIn);

'enc_AttributeValue'(Val, TagIn) ->
?RT_BER:encode_octet_string([], Val, TagIn ++ []).


'dec_AttributeValue'(Bytes, OptOrMand) ->
   'dec_AttributeValue'(Bytes, OptOrMand, []).

'dec_AttributeValue'(Bytes, OptOrMand, TagIn) ->
?RT_BER:decode_octet_string(Bytes,[],TagIn++[], no_length, OptOrMand).



%%================================
%%  AttributeValueAssertion
%%================================
'enc_AttributeValueAssertion'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,attributeDesc), []),

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(3,Val,assertionValue), []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).


'dec_AttributeValueAssertion'(Bytes, OptOrMand) ->
   'dec_AttributeValueAssertion'(Bytes, OptOrMand, []).

'dec_AttributeValueAssertion'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = ?RT_BER:decode_octet_string(Bytes3,[],[], no_length, mandatory),

   {Bytes5,Rb4} = ?RT_BER:restbytes2(RemBytes, Bytes4,noext),
   {{'AttributeValueAssertion', Term1, Term2}, Bytes5, Rb1+Rb2+Rb3+Rb4}.


%%================================
%%  AssertionValue
%%================================

'enc_AssertionValue'({'AssertionValue',Val}, TagIn) ->
   'enc_AssertionValue'(Val, TagIn);

'enc_AssertionValue'(Val, TagIn) ->
?RT_BER:encode_octet_string([], Val, TagIn ++ []).


'dec_AssertionValue'(Bytes, OptOrMand) ->
   'dec_AssertionValue'(Bytes, OptOrMand, []).

'dec_AssertionValue'(Bytes, OptOrMand, TagIn) ->
?RT_BER:decode_octet_string(Bytes,[],TagIn++[], no_length, OptOrMand).



%%================================
%%  Attribute
%%================================
'enc_Attribute'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,type), []),

%%-------------------------------------------------
%% attribute number 2 with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Attribute_vals'(?RT_BER:cindex(3,Val,vals), []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).



%%================================
%%  Attribute_vals
%%================================

'enc_Attribute_vals'({'Attribute_vals',Val}, TagIn) ->
   'enc_Attribute_vals'(Val, TagIn);

'enc_Attribute_vals'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Attribute_vals_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn ++ [{tag,0,17,'IMPLICIT',32}], EncBytes, EncLen).

'enc_Attribute_vals_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Attribute_vals_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = ?RT_BER:encode_octet_string([], H, []),
   'enc_Attribute_vals_components'(T,[EncBytes|AccBytes], AccLen + EncLen).

'dec_Attribute_vals'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,17,'IMPLICIT',32}], Bytes, OptOrMand), 
   ?RT_BER:decode_components(Rb1, Len, Bytes1, fun(FBytes,_,_)->
?RT_BER:decode_octet_string(FBytes,[],[], no_length, mandatory)
end, [], []).




'dec_Attribute'(Bytes, OptOrMand) ->
   'dec_Attribute'(Bytes, OptOrMand, []).

'dec_Attribute'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2 with type SET OF
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = 'dec_Attribute_vals'(Bytes3, mandatory, []),

   {Bytes5,Rb4} = ?RT_BER:restbytes2(RemBytes, Bytes4,noext),
   {{'Attribute', Term1, Term2}, Bytes5, Rb1+Rb2+Rb3+Rb4}.


%%================================
%%  MatchingRuleId
%%================================

'enc_MatchingRuleId'({'MatchingRuleId',Val}, TagIn) ->
   'enc_MatchingRuleId'(Val, TagIn);

'enc_MatchingRuleId'(Val, TagIn) ->
?RT_BER:encode_octet_string([], Val, TagIn ++ []).


'dec_MatchingRuleId'(Bytes, OptOrMand) ->
   'dec_MatchingRuleId'(Bytes, OptOrMand, []).

'dec_MatchingRuleId'(Bytes, OptOrMand, TagIn) ->
?RT_BER:decode_octet_string(Bytes,[],TagIn++[], no_length, OptOrMand).



%%================================
%%  LDAPResult
%%================================
'enc_LDAPResult'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case (case ?RT_BER:cindex(2,Val,resultCode) of {_,_}->element(2,?RT_BER:cindex(2,Val,resultCode));_->?RT_BER:cindex(2,Val,resultCode) end) of
success -> ?RT_BER:encode_enumerated(0,[]);
operationsError -> ?RT_BER:encode_enumerated(1,[]);
protocolError -> ?RT_BER:encode_enumerated(2,[]);
timeLimitExceeded -> ?RT_BER:encode_enumerated(3,[]);
sizeLimitExceeded -> ?RT_BER:encode_enumerated(4,[]);
compareFalse -> ?RT_BER:encode_enumerated(5,[]);
compareTrue -> ?RT_BER:encode_enumerated(6,[]);
authMethodNotSupported -> ?RT_BER:encode_enumerated(7,[]);
strongAuthRequired -> ?RT_BER:encode_enumerated(8,[]);
referral -> ?RT_BER:encode_enumerated(10,[]);
adminLimitExceeded -> ?RT_BER:encode_enumerated(11,[]);
unavailableCriticalExtension -> ?RT_BER:encode_enumerated(12,[]);
confidentialityRequired -> ?RT_BER:encode_enumerated(13,[]);
saslBindInProgress -> ?RT_BER:encode_enumerated(14,[]);
noSuchAttribute -> ?RT_BER:encode_enumerated(16,[]);
undefinedAttributeType -> ?RT_BER:encode_enumerated(17,[]);
inappropriateMatching -> ?RT_BER:encode_enumerated(18,[]);
constraintViolation -> ?RT_BER:encode_enumerated(19,[]);
attributeOrValueExists -> ?RT_BER:encode_enumerated(20,[]);
invalidAttributeSyntax -> ?RT_BER:encode_enumerated(21,[]);
noSuchObject -> ?RT_BER:encode_enumerated(32,[]);
aliasProblem -> ?RT_BER:encode_enumerated(33,[]);
invalidDNSyntax -> ?RT_BER:encode_enumerated(34,[]);
aliasDereferencingProblem -> ?RT_BER:encode_enumerated(36,[]);
inappropriateAuthentication -> ?RT_BER:encode_enumerated(48,[]);
invalidCredentials -> ?RT_BER:encode_enumerated(49,[]);
insufficientAccessRights -> ?RT_BER:encode_enumerated(50,[]);
busy -> ?RT_BER:encode_enumerated(51,[]);
unavailable -> ?RT_BER:encode_enumerated(52,[]);
unwillingToPerform -> ?RT_BER:encode_enumerated(53,[]);
loopDetect -> ?RT_BER:encode_enumerated(54,[]);
namingViolation -> ?RT_BER:encode_enumerated(64,[]);
objectClassViolation -> ?RT_BER:encode_enumerated(65,[]);
notAllowedOnNonLeaf -> ?RT_BER:encode_enumerated(66,[]);
notAllowedOnRDN -> ?RT_BER:encode_enumerated(67,[]);
entryAlreadyExists -> ?RT_BER:encode_enumerated(68,[]);
objectClassModsProhibited -> ?RT_BER:encode_enumerated(69,[]);
affectsMultipleDSAs -> ?RT_BER:encode_enumerated(71,[]);
other -> ?RT_BER:encode_enumerated(80,[]);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(3,Val,matchedDN), []),

%%-------------------------------------------------
%% attribute number 3 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(4,Val,errorMessage), []),

%%-------------------------------------------------
%% attribute number 4   External LDAPv3:Referral OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case ?RT_BER:cindex(5,Val,referral) of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Referral'(?RT_BER:cindex(5,Val,referral), [{tag,128,3,'IMPLICIT',32}])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).


'dec_LDAPResult'(Bytes, OptOrMand) ->
   'dec_LDAPResult'(Bytes, OptOrMand, []).

'dec_LDAPResult'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type ENUMERATED
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_enumerated(Bytes2,[],[{success,0},{operationsError,1},{protocolError,2},{timeLimitExceeded,3},{sizeLimitExceeded,4},{compareFalse,5},{compareTrue,6},{authMethodNotSupported,7},{strongAuthRequired,8},{referral,10},{adminLimitExceeded,11},{unavailableCriticalExtension,12},{confidentialityRequired,13},{saslBindInProgress,14},{noSuchAttribute,16},{undefinedAttributeType,17},{inappropriateMatching,18},{constraintViolation,19},{attributeOrValueExists,20},{invalidAttributeSyntax,21},{noSuchObject,32},{aliasProblem,33},{invalidDNSyntax,34},{aliasDereferencingProblem,36},{inappropriateAuthentication,48},{invalidCredentials,49},{insufficientAccessRights,50},{busy,51},{unavailable,52},{unwillingToPerform,53},{loopDetect,54},{namingViolation,64},{objectClassViolation,65},{notAllowedOnNonLeaf,66},{notAllowedOnRDN,67},{entryAlreadyExists,68},{objectClassModsProhibited,69},{affectsMultipleDSAs,71},{other,80}],[], mandatory),

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = ?RT_BER:decode_octet_string(Bytes3,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 3 with type OCTET STRING
%%-------------------------------------------------
   {Term3,Bytes5,Rb4} = ?RT_BER:decode_octet_string(Bytes4,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 4   External LDAPv3:Referral OPTIONAL
%%-------------------------------------------------
   {Term4,Bytes6,Rb5} = case Bytes5 of
<<2:2,_:1,3:5,_/binary>> ->
'dec_Referral'(Bytes5, opt_or_default, [{tag,128,3,'IMPLICIT',32}]);
_ ->
{ asn1_NOVALUE, Bytes5, 0 }
end,

   {Bytes7,Rb6} = ?RT_BER:restbytes2(RemBytes, Bytes6,noext),
   {{'LDAPResult', Term1, Term2, Term3, Term4}, Bytes7, Rb1+Rb2+Rb3+Rb4+Rb5+Rb6}.


%%================================
%%  Referral
%%================================

'enc_Referral'({'Referral',Val}, TagIn) ->
   'enc_Referral'(Val, TagIn);

'enc_Referral'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Referral_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], EncBytes, EncLen).

'enc_Referral_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Referral_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = ?RT_BER:encode_octet_string([], H, []),
   'enc_Referral_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_Referral'(Bytes, OptOrMand) ->
   'dec_Referral'(Bytes, OptOrMand, []).

'dec_Referral'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
   ?RT_BER:decode_components(Rb1, Len, Bytes1, fun(FBytes,_,_)->
?RT_BER:decode_octet_string(FBytes,[],[], no_length, mandatory)
end, [], []).




%%================================
%%  LDAPURL
%%================================

'enc_LDAPURL'({'LDAPURL',Val}, TagIn) ->
   'enc_LDAPURL'(Val, TagIn);

'enc_LDAPURL'(Val, TagIn) ->
?RT_BER:encode_octet_string([], Val, TagIn ++ []).


'dec_LDAPURL'(Bytes, OptOrMand) ->
   'dec_LDAPURL'(Bytes, OptOrMand, []).

'dec_LDAPURL'(Bytes, OptOrMand, TagIn) ->
?RT_BER:decode_octet_string(Bytes,[],TagIn++[], no_length, OptOrMand).



%%================================
%%  Controls
%%================================

'enc_Controls'({'Controls',Val}, TagIn) ->
   'enc_Controls'(Val, TagIn);

'enc_Controls'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Controls_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], EncBytes, EncLen).

'enc_Controls_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Controls_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Control'(H, []),
   'enc_Controls_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_Controls'(Bytes, OptOrMand) ->
   'dec_Controls'(Bytes, OptOrMand, []).

'dec_Controls'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
   ?RT_BER:decode_components(Rb1, Len, Bytes1, fun 'dec_Control'/3, [], []).




%%================================
%%  Control
%%================================
'enc_Control'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,controlType), []),

%%-------------------------------------------------
%% attribute number 2 with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case ?RT_BER:cindex(3,Val,criticality) of
         asn1_DEFAULT -> {<<>>,0};
         false -> {<<>>,0};
         _ ->
            ?RT_BER:encode_boolean(?RT_BER:cindex(3,Val,criticality), [])
       end,

%%-------------------------------------------------
%% attribute number 3 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case ?RT_BER:cindex(4,Val,controlValue) of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_octet_string([], ?RT_BER:cindex(4,Val,controlValue), [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).


'dec_Control'(Bytes, OptOrMand) ->
   'dec_Control'(Bytes, OptOrMand, []).

'dec_Control'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2 with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = case Bytes3 of
<<0:2,_:1,1:5,_/binary>> ->
?RT_BER:decode_boolean(Bytes3,[], mandatory);
_ ->
{false,Bytes3, 0 }
end,

%%-------------------------------------------------
%% attribute number 3 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {Term3,Bytes5,Rb4} = case Bytes4 of
<<0:2,_:1,4:5,_/binary>> ->
?RT_BER:decode_octet_string(Bytes4,[],[], no_length, mandatory);
_ ->
{ asn1_NOVALUE, Bytes4, 0 }
end,

   {Bytes6,Rb5} = ?RT_BER:restbytes2(RemBytes, Bytes5,noext),
   {{'Control', Term1, Term2, Term3}, Bytes6, Rb1+Rb2+Rb3+Rb4+Rb5}.


%%================================
%%  BindRequest
%%================================
'enc_BindRequest'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_integer([], ?RT_BER:cindex(2,Val,version), []),

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(3,Val,name), []),

%%-------------------------------------------------
%% attribute number 3   External LDAPv3:AuthenticationChoice
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_AuthenticationChoice'(?RT_BER:cindex(4,Val,authentication), []),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,64,0,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).


'dec_BindRequest'(Bytes, OptOrMand) ->
   'dec_BindRequest'(Bytes, OptOrMand, []).

'dec_BindRequest'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,64,0,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type INTEGER
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_integer(Bytes2,{1,127},[], mandatory),

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = ?RT_BER:decode_octet_string(Bytes3,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 3   External LDAPv3:AuthenticationChoice
%%-------------------------------------------------
   {Term3,Bytes5,Rb4} = 'dec_AuthenticationChoice'(Bytes4, mandatory, []),

   {Bytes6,Rb5} = ?RT_BER:restbytes2(RemBytes, Bytes5,noext),
   {{'BindRequest', Term1, Term2, Term3}, Bytes6, Rb1+Rb2+Rb3+Rb4+Rb5}.


%%================================
%%  AuthenticationChoice
%%================================

'enc_AuthenticationChoice'({'AuthenticationChoice',Val}, TagIn) ->
   'enc_AuthenticationChoice'(Val, TagIn);

'enc_AuthenticationChoice'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      simple ->
         ?RT_BER:encode_octet_string([], element(2,Val), [{tag,128,0,'IMPLICIT',32}]);
      sasl ->
         'enc_SaslCredentials'(element(2,Val), [{tag,128,3,'IMPLICIT',32}]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn ++[], EncBytes, EncLen).




'dec_AuthenticationChoice'(Bytes, OptOrMand) ->
   'dec_AuthenticationChoice'(Bytes, OptOrMand, []).

'dec_AuthenticationChoice'(Bytes, OptOrMand, TagIn) ->
   {{_,Len},Bytes1, RbExp} = ?RT_BER:check_tags(TagIn++[], Bytes, OptOrMand),
   IndefEndBytes = fun(indefinite,<<0,0,R/binary>>)-> R; (_,B)-> B end,
   IndefEndRb = fun(indefinite,<<0,0,R/binary>>)-> 2; (_,_)-> 0 end,
   case Bytes1 of

%% 'simple'
      <<2:2,_:1,0:5,_/binary>> ->
         {Dec, Rest, RbCho} = ?RT_BER:decode_octet_string(Bytes1,[],[{tag,128,0,'IMPLICIT',32}], no_length, mandatory),
         {{simple, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'sasl'
      <<2:2,_:1,3:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_SaslCredentials'(Bytes1, mandatory, [{tag,128,3,'IMPLICIT',32}]),
         {{sasl, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};

      Else -> 
         case OptOrMand of
            mandatory ->exit({error,{asn1,{invalid_choice_tag,Else}}});
            _ ->exit({error,{asn1,{no_optional_tag,Else}}})
         end
   end.


%%================================
%%  SaslCredentials
%%================================
'enc_SaslCredentials'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,mechanism), []),

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case ?RT_BER:cindex(3,Val,credentials) of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_octet_string([], ?RT_BER:cindex(3,Val,credentials), [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).


'dec_SaslCredentials'(Bytes, OptOrMand) ->
   'dec_SaslCredentials'(Bytes, OptOrMand, []).

'dec_SaslCredentials'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = case Bytes3 of
<<0:2,_:1,4:5,_/binary>> ->
?RT_BER:decode_octet_string(Bytes3,[],[], no_length, mandatory);
_ ->
{ asn1_NOVALUE, Bytes3, 0 }
end,

   {Bytes5,Rb4} = ?RT_BER:restbytes2(RemBytes, Bytes4,noext),
   {{'SaslCredentials', Term1, Term2}, Bytes5, Rb1+Rb2+Rb3+Rb4}.


%%================================
%%  BindResponse
%%================================
'enc_BindResponse'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case (case ?RT_BER:cindex(2,Val,resultCode) of {_,_}->element(2,?RT_BER:cindex(2,Val,resultCode));_->?RT_BER:cindex(2,Val,resultCode) end) of
success -> ?RT_BER:encode_enumerated(0,[]);
operationsError -> ?RT_BER:encode_enumerated(1,[]);
protocolError -> ?RT_BER:encode_enumerated(2,[]);
timeLimitExceeded -> ?RT_BER:encode_enumerated(3,[]);
sizeLimitExceeded -> ?RT_BER:encode_enumerated(4,[]);
compareFalse -> ?RT_BER:encode_enumerated(5,[]);
compareTrue -> ?RT_BER:encode_enumerated(6,[]);
authMethodNotSupported -> ?RT_BER:encode_enumerated(7,[]);
strongAuthRequired -> ?RT_BER:encode_enumerated(8,[]);
referral -> ?RT_BER:encode_enumerated(10,[]);
adminLimitExceeded -> ?RT_BER:encode_enumerated(11,[]);
unavailableCriticalExtension -> ?RT_BER:encode_enumerated(12,[]);
confidentialityRequired -> ?RT_BER:encode_enumerated(13,[]);
saslBindInProgress -> ?RT_BER:encode_enumerated(14,[]);
noSuchAttribute -> ?RT_BER:encode_enumerated(16,[]);
undefinedAttributeType -> ?RT_BER:encode_enumerated(17,[]);
inappropriateMatching -> ?RT_BER:encode_enumerated(18,[]);
constraintViolation -> ?RT_BER:encode_enumerated(19,[]);
attributeOrValueExists -> ?RT_BER:encode_enumerated(20,[]);
invalidAttributeSyntax -> ?RT_BER:encode_enumerated(21,[]);
noSuchObject -> ?RT_BER:encode_enumerated(32,[]);
aliasProblem -> ?RT_BER:encode_enumerated(33,[]);
invalidDNSyntax -> ?RT_BER:encode_enumerated(34,[]);
aliasDereferencingProblem -> ?RT_BER:encode_enumerated(36,[]);
inappropriateAuthentication -> ?RT_BER:encode_enumerated(48,[]);
invalidCredentials -> ?RT_BER:encode_enumerated(49,[]);
insufficientAccessRights -> ?RT_BER:encode_enumerated(50,[]);
busy -> ?RT_BER:encode_enumerated(51,[]);
unavailable -> ?RT_BER:encode_enumerated(52,[]);
unwillingToPerform -> ?RT_BER:encode_enumerated(53,[]);
loopDetect -> ?RT_BER:encode_enumerated(54,[]);
namingViolation -> ?RT_BER:encode_enumerated(64,[]);
objectClassViolation -> ?RT_BER:encode_enumerated(65,[]);
notAllowedOnNonLeaf -> ?RT_BER:encode_enumerated(66,[]);
notAllowedOnRDN -> ?RT_BER:encode_enumerated(67,[]);
entryAlreadyExists -> ?RT_BER:encode_enumerated(68,[]);
objectClassModsProhibited -> ?RT_BER:encode_enumerated(69,[]);
affectsMultipleDSAs -> ?RT_BER:encode_enumerated(71,[]);
other -> ?RT_BER:encode_enumerated(80,[]);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(3,Val,matchedDN), []),

%%-------------------------------------------------
%% attribute number 3 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(4,Val,errorMessage), []),

%%-------------------------------------------------
%% attribute number 4   External LDAPv3:Referral OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case ?RT_BER:cindex(5,Val,referral) of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Referral'(?RT_BER:cindex(5,Val,referral), [{tag,128,3,'IMPLICIT',32}])
       end,

%%-------------------------------------------------
%% attribute number 5 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case ?RT_BER:cindex(6,Val,serverSaslCreds) of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_octet_string([], ?RT_BER:cindex(6,Val,serverSaslCreds), [{tag,128,7,'IMPLICIT',32}])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,64,1,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).


'dec_BindResponse'(Bytes, OptOrMand) ->
   'dec_BindResponse'(Bytes, OptOrMand, []).

'dec_BindResponse'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,64,1,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type ENUMERATED
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_enumerated(Bytes2,[],[{success,0},{operationsError,1},{protocolError,2},{timeLimitExceeded,3},{sizeLimitExceeded,4},{compareFalse,5},{compareTrue,6},{authMethodNotSupported,7},{strongAuthRequired,8},{referral,10},{adminLimitExceeded,11},{unavailableCriticalExtension,12},{confidentialityRequired,13},{saslBindInProgress,14},{noSuchAttribute,16},{undefinedAttributeType,17},{inappropriateMatching,18},{constraintViolation,19},{attributeOrValueExists,20},{invalidAttributeSyntax,21},{noSuchObject,32},{aliasProblem,33},{invalidDNSyntax,34},{aliasDereferencingProblem,36},{inappropriateAuthentication,48},{invalidCredentials,49},{insufficientAccessRights,50},{busy,51},{unavailable,52},{unwillingToPerform,53},{loopDetect,54},{namingViolation,64},{objectClassViolation,65},{notAllowedOnNonLeaf,66},{notAllowedOnRDN,67},{entryAlreadyExists,68},{objectClassModsProhibited,69},{affectsMultipleDSAs,71},{other,80}],[], mandatory),

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = ?RT_BER:decode_octet_string(Bytes3,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 3 with type OCTET STRING
%%-------------------------------------------------
   {Term3,Bytes5,Rb4} = ?RT_BER:decode_octet_string(Bytes4,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 4   External LDAPv3:Referral OPTIONAL
%%-------------------------------------------------
   {Term4,Bytes6,Rb5} = case Bytes5 of
<<2:2,_:1,3:5,_/binary>> ->
'dec_Referral'(Bytes5, opt_or_default, [{tag,128,3,'IMPLICIT',32}]);
_ ->
{ asn1_NOVALUE, Bytes5, 0 }
end,

%%-------------------------------------------------
%% attribute number 5 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {Term5,Bytes7,Rb6} = case Bytes6 of
<<2:2,_:1,7:5,_/binary>> ->
?RT_BER:decode_octet_string(Bytes6,[],[{tag,128,7,'IMPLICIT',32}], no_length, mandatory);
_ ->
{ asn1_NOVALUE, Bytes6, 0 }
end,

   {Bytes8,Rb7} = ?RT_BER:restbytes2(RemBytes, Bytes7,noext),
   {{'BindResponse', Term1, Term2, Term3, Term4, Term5}, Bytes8, Rb1+Rb2+Rb3+Rb4+Rb5+Rb6+Rb7}.


%%================================
%%  UnbindRequest
%%================================

'enc_UnbindRequest'({'UnbindRequest',Val}, TagIn) ->
   'enc_UnbindRequest'(Val, TagIn);

'enc_UnbindRequest'(Val, TagIn) ->
?RT_BER:encode_null(Val, TagIn ++ [{tag,64,2,'IMPLICIT',32}]).


'dec_UnbindRequest'(Bytes, OptOrMand) ->
   'dec_UnbindRequest'(Bytes, OptOrMand, []).

'dec_UnbindRequest'(Bytes, OptOrMand, TagIn) ->
?RT_BER:decode_null(Bytes,TagIn++[{tag,64,2,'IMPLICIT',32}], OptOrMand).



%%================================
%%  SearchRequest
%%================================
'enc_SearchRequest'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,baseObject), []),

%%-------------------------------------------------
%% attribute number 2 with type ENUMERATED
%%-------------------------------------------------
   {EncBytes2,EncLen2} = case (case ?RT_BER:cindex(3,Val,scope) of {_,_}->element(2,?RT_BER:cindex(3,Val,scope));_->?RT_BER:cindex(3,Val,scope) end) of
baseObject -> ?RT_BER:encode_enumerated(0,[]);
singleLevel -> ?RT_BER:encode_enumerated(1,[]);
wholeSubtree -> ?RT_BER:encode_enumerated(2,[]);
Enumval2 -> exit({error,{asn1, {enumerated_not_in_range,Enumval2}}})
end,

%%-------------------------------------------------
%% attribute number 3 with type ENUMERATED
%%-------------------------------------------------
   {EncBytes3,EncLen3} = case (case ?RT_BER:cindex(4,Val,derefAliases) of {_,_}->element(2,?RT_BER:cindex(4,Val,derefAliases));_->?RT_BER:cindex(4,Val,derefAliases) end) of
neverDerefAliases -> ?RT_BER:encode_enumerated(0,[]);
derefInSearching -> ?RT_BER:encode_enumerated(1,[]);
derefFindingBaseObj -> ?RT_BER:encode_enumerated(2,[]);
derefAlways -> ?RT_BER:encode_enumerated(3,[]);
Enumval3 -> exit({error,{asn1, {enumerated_not_in_range,Enumval3}}})
end,

%%-------------------------------------------------
%% attribute number 4 with type INTEGER
%%-------------------------------------------------
   {EncBytes4,EncLen4} = ?RT_BER:encode_integer([], ?RT_BER:cindex(5,Val,sizeLimit), []),

%%-------------------------------------------------
%% attribute number 5 with type INTEGER
%%-------------------------------------------------
   {EncBytes5,EncLen5} = ?RT_BER:encode_integer([], ?RT_BER:cindex(6,Val,timeLimit), []),

%%-------------------------------------------------
%% attribute number 6 with type BOOLEAN
%%-------------------------------------------------
   {EncBytes6,EncLen6} = ?RT_BER:encode_boolean(?RT_BER:cindex(7,Val,typesOnly), []),

%%-------------------------------------------------
%% attribute number 7   External LDAPv3:Filter
%%-------------------------------------------------
   {EncBytes7,EncLen7} = 'enc_Filter'(?RT_BER:cindex(8,Val,filter), []),

%%-------------------------------------------------
%% attribute number 8   External LDAPv3:AttributeDescriptionList
%%-------------------------------------------------
   {EncBytes8,EncLen8} = 'enc_AttributeDescriptionList'(?RT_BER:cindex(9,Val,attributes), []),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,64,3,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).


'dec_SearchRequest'(Bytes, OptOrMand) ->
   'dec_SearchRequest'(Bytes, OptOrMand, []).

'dec_SearchRequest'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,64,3,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2 with type ENUMERATED
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = ?RT_BER:decode_enumerated(Bytes3,[],[{baseObject,0},{singleLevel,1},{wholeSubtree,2}],[], mandatory),

%%-------------------------------------------------
%% attribute number 3 with type ENUMERATED
%%-------------------------------------------------
   {Term3,Bytes5,Rb4} = ?RT_BER:decode_enumerated(Bytes4,[],[{neverDerefAliases,0},{derefInSearching,1},{derefFindingBaseObj,2},{derefAlways,3}],[], mandatory),

%%-------------------------------------------------
%% attribute number 4 with type INTEGER
%%-------------------------------------------------
   {Term4,Bytes6,Rb5} = ?RT_BER:decode_integer(Bytes5,{0,2147483647},[], mandatory),

%%-------------------------------------------------
%% attribute number 5 with type INTEGER
%%-------------------------------------------------
   {Term5,Bytes7,Rb6} = ?RT_BER:decode_integer(Bytes6,{0,2147483647},[], mandatory),

%%-------------------------------------------------
%% attribute number 6 with type BOOLEAN
%%-------------------------------------------------
   {Term6,Bytes8,Rb7} = ?RT_BER:decode_boolean(Bytes7,[], mandatory),

%%-------------------------------------------------
%% attribute number 7   External LDAPv3:Filter
%%-------------------------------------------------
   {Term7,Bytes9,Rb8} = 'dec_Filter'(Bytes8, mandatory, []),

%%-------------------------------------------------
%% attribute number 8   External LDAPv3:AttributeDescriptionList
%%-------------------------------------------------
   {Term8,Bytes10,Rb9} = 'dec_AttributeDescriptionList'(Bytes9, mandatory, []),

   {Bytes11,Rb10} = ?RT_BER:restbytes2(RemBytes, Bytes10,noext),
   {{'SearchRequest', Term1, Term2, Term3, Term4, Term5, Term6, Term7, Term8}, Bytes11, Rb1+Rb2+Rb3+Rb4+Rb5+Rb6+Rb7+Rb8+Rb9+Rb10}.


%%================================
%%  Filter
%%================================

'enc_Filter'({'Filter',Val}, TagIn) ->
   'enc_Filter'(Val, TagIn);

'enc_Filter'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      'and' ->
         'enc_Filter_and'(element(2,Val), [{tag,128,0,'IMPLICIT',32}]);
      'or' ->
         'enc_Filter_or'(element(2,Val), [{tag,128,1,'IMPLICIT',32}]);
      'not' ->
         'enc_Filter'(element(2,Val), [{tag,128,2,'EXPLICIT',32}]);
      equalityMatch ->
         'enc_AttributeValueAssertion'(element(2,Val), [{tag,128,3,'IMPLICIT',32}]);
      substrings ->
         'enc_SubstringFilter'(element(2,Val), [{tag,128,4,'IMPLICIT',32}]);
      greaterOrEqual ->
         'enc_AttributeValueAssertion'(element(2,Val), [{tag,128,5,'IMPLICIT',32}]);
      lessOrEqual ->
         'enc_AttributeValueAssertion'(element(2,Val), [{tag,128,6,'IMPLICIT',32}]);
      present ->
         ?RT_BER:encode_octet_string([], element(2,Val), [{tag,128,7,'IMPLICIT',32}]);
      approxMatch ->
         'enc_AttributeValueAssertion'(element(2,Val), [{tag,128,8,'IMPLICIT',32}]);
      extensibleMatch ->
         'enc_MatchingRuleAssertion'(element(2,Val), [{tag,128,9,'IMPLICIT',32}]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn ++[], EncBytes, EncLen).





%%================================
%%  Filter_and
%%================================

'enc_Filter_and'({'Filter_and',Val}, TagIn) ->
   'enc_Filter_and'(Val, TagIn);

'enc_Filter_and'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Filter_and_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn ++ [{tag,0,17,'IMPLICIT',32}], EncBytes, EncLen).

'enc_Filter_and_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Filter_and_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Filter'(H, []),
   'enc_Filter_and_components'(T,[EncBytes|AccBytes], AccLen + EncLen).

'dec_Filter_and'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,17,'IMPLICIT',32}], Bytes, OptOrMand), 
   ?RT_BER:decode_components(Rb1, Len, Bytes1, fun 'dec_Filter'/3, [], []).





%%================================
%%  Filter_or
%%================================

'enc_Filter_or'({'Filter_or',Val}, TagIn) ->
   'enc_Filter_or'(Val, TagIn);

'enc_Filter_or'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Filter_or_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn ++ [{tag,0,17,'IMPLICIT',32}], EncBytes, EncLen).

'enc_Filter_or_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Filter_or_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Filter'(H, []),
   'enc_Filter_or_components'(T,[EncBytes|AccBytes], AccLen + EncLen).

'dec_Filter_or'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,17,'IMPLICIT',32}], Bytes, OptOrMand), 
   ?RT_BER:decode_components(Rb1, Len, Bytes1, fun 'dec_Filter'/3, [], []).




'dec_Filter'(Bytes, OptOrMand) ->
   'dec_Filter'(Bytes, OptOrMand, []).

'dec_Filter'(Bytes, OptOrMand, TagIn) ->
   {{_,Len},Bytes1, RbExp} = ?RT_BER:check_tags(TagIn++[], Bytes, OptOrMand),
   IndefEndBytes = fun(indefinite,<<0,0,R/binary>>)-> R; (_,B)-> B end,
   IndefEndRb = fun(indefinite,<<0,0,R/binary>>)-> 2; (_,_)-> 0 end,
   case Bytes1 of

%% 'and'
      <<2:2,_:1,0:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_Filter_and'(Bytes1, mandatory, [{tag,128,0,'IMPLICIT',32}]),
         {{'and', Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'or'
      <<2:2,_:1,1:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_Filter_or'(Bytes1, mandatory, [{tag,128,1,'IMPLICIT',32}]),
         {{'or', Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'not'
      <<2:2,_:1,2:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_Filter'(Bytes1, mandatory, [{tag,128,2,'EXPLICIT',32}]),
         {{'not', Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'equalityMatch'
      <<2:2,_:1,3:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_AttributeValueAssertion'(Bytes1, mandatory, [{tag,128,3,'IMPLICIT',32}]),
         {{equalityMatch, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'substrings'
      <<2:2,_:1,4:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_SubstringFilter'(Bytes1, mandatory, [{tag,128,4,'IMPLICIT',32}]),
         {{substrings, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'greaterOrEqual'
      <<2:2,_:1,5:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_AttributeValueAssertion'(Bytes1, mandatory, [{tag,128,5,'IMPLICIT',32}]),
         {{greaterOrEqual, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'lessOrEqual'
      <<2:2,_:1,6:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_AttributeValueAssertion'(Bytes1, mandatory, [{tag,128,6,'IMPLICIT',32}]),
         {{lessOrEqual, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'present'
      <<2:2,_:1,7:5,_/binary>> ->
         {Dec, Rest, RbCho} = ?RT_BER:decode_octet_string(Bytes1,[],[{tag,128,7,'IMPLICIT',32}], no_length, mandatory),
         {{present, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'approxMatch'
      <<2:2,_:1,8:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_AttributeValueAssertion'(Bytes1, mandatory, [{tag,128,8,'IMPLICIT',32}]),
         {{approxMatch, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'extensibleMatch'
      <<2:2,_:1,9:5,_/binary>> ->
         {Dec, Rest, RbCho} = 'dec_MatchingRuleAssertion'(Bytes1, mandatory, [{tag,128,9,'IMPLICIT',32}]),
         {{extensibleMatch, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};

      Else -> 
         case OptOrMand of
            mandatory ->exit({error,{asn1,{invalid_choice_tag,Else}}});
            _ ->exit({error,{asn1,{no_optional_tag,Else}}})
         end
   end.


%%================================
%%  SubstringFilter
%%================================
'enc_SubstringFilter'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,type), []),

%%-------------------------------------------------
%% attribute number 2 with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SubstringFilter_substrings'(?RT_BER:cindex(3,Val,substrings), []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).



%%================================
%%  SubstringFilter_substrings
%%================================

'enc_SubstringFilter_substrings'({'SubstringFilter_substrings',Val}, TagIn) ->
   'enc_SubstringFilter_substrings'(Val, TagIn);

'enc_SubstringFilter_substrings'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_SubstringFilter_substrings_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], EncBytes, EncLen).

'enc_SubstringFilter_substrings_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SubstringFilter_substrings_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SubstringFilter_substrings_SEQOF'(H, []),
   'enc_SubstringFilter_substrings_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  SubstringFilter_substrings_SEQOF
%%================================

'enc_SubstringFilter_substrings_SEQOF'({'SubstringFilter_substrings_SEQOF',Val}, TagIn) ->
   'enc_SubstringFilter_substrings_SEQOF'(Val, TagIn);

'enc_SubstringFilter_substrings_SEQOF'(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      initial ->
         ?RT_BER:encode_octet_string([], element(2,Val), [{tag,128,0,'IMPLICIT',32}]);
      any ->
         ?RT_BER:encode_octet_string([], element(2,Val), [{tag,128,1,'IMPLICIT',32}]);
      final ->
         ?RT_BER:encode_octet_string([], element(2,Val), [{tag,128,2,'IMPLICIT',32}]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn ++[], EncBytes, EncLen).


'dec_SubstringFilter_substrings_SEQOF'(Bytes, OptOrMand, TagIn) ->
   {{_,Len},Bytes1, RbExp} = ?RT_BER:check_tags(TagIn++[], Bytes, OptOrMand),
   IndefEndBytes = fun(indefinite,<<0,0,R/binary>>)-> R; (_,B)-> B end,
   IndefEndRb = fun(indefinite,<<0,0,R/binary>>)-> 2; (_,_)-> 0 end,
   case Bytes1 of

%% 'initial'
      <<2:2,_:1,0:5,_/binary>> ->
         {Dec, Rest, RbCho} = ?RT_BER:decode_octet_string(Bytes1,[],[{tag,128,0,'IMPLICIT',32}], no_length, mandatory),
         {{initial, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'any'
      <<2:2,_:1,1:5,_/binary>> ->
         {Dec, Rest, RbCho} = ?RT_BER:decode_octet_string(Bytes1,[],[{tag,128,1,'IMPLICIT',32}], no_length, mandatory),
         {{any, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};


%% 'final'
      <<2:2,_:1,2:5,_/binary>> ->
         {Dec, Rest, RbCho} = ?RT_BER:decode_octet_string(Bytes1,[],[{tag,128,2,'IMPLICIT',32}], no_length, mandatory),
         {{final, Dec}, IndefEndBytes(Len,Rest), RbExp + RbCho + IndefEndRb(Len,Rest)};

      Else -> 
         case OptOrMand of
            mandatory ->exit({error,{asn1,{invalid_choice_tag,Else}}});
            _ ->exit({error,{asn1,{no_optional_tag,Else}}})
         end
   end.
'dec_SubstringFilter_substrings'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
   ?RT_BER:decode_components(Rb1, Len, Bytes1, fun 'dec_SubstringFilter_substrings_SEQOF'/3, [], []).




'dec_SubstringFilter'(Bytes, OptOrMand) ->
   'dec_SubstringFilter'(Bytes, OptOrMand, []).

'dec_SubstringFilter'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2 with type SEQUENCE OF
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = 'dec_SubstringFilter_substrings'(Bytes3, mandatory, []),

   {Bytes5,Rb4} = ?RT_BER:restbytes2(RemBytes, Bytes4,noext),
   {{'SubstringFilter', Term1, Term2}, Bytes5, Rb1+Rb2+Rb3+Rb4}.


%%================================
%%  MatchingRuleAssertion
%%================================
'enc_MatchingRuleAssertion'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case ?RT_BER:cindex(2,Val,matchingRule) of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,matchingRule), [{tag,128,1,'IMPLICIT',32}])
       end,

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case ?RT_BER:cindex(3,Val,type) of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_octet_string([], ?RT_BER:cindex(3,Val,type), [{tag,128,2,'IMPLICIT',32}])
       end,

%%-------------------------------------------------
%% attribute number 3 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(4,Val,matchValue), [{tag,128,3,'IMPLICIT',32}]),

%%-------------------------------------------------
%% attribute number 4 with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case ?RT_BER:cindex(5,Val,dnAttributes) of
         asn1_DEFAULT -> {<<>>,0};
         false -> {<<>>,0};
         _ ->
            ?RT_BER:encode_boolean(?RT_BER:cindex(5,Val,dnAttributes), [{tag,128,4,'IMPLICIT',32}])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).


'dec_MatchingRuleAssertion'(Bytes, OptOrMand) ->
   'dec_MatchingRuleAssertion'(Bytes, OptOrMand, []).

'dec_MatchingRuleAssertion'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = case Bytes2 of
<<2:2,_:1,1:5,_/binary>> ->
?RT_BER:decode_octet_string(Bytes2,[],[{tag,128,1,'IMPLICIT',32}], no_length, mandatory);
_ ->
{ asn1_NOVALUE, Bytes2, 0 }
end,

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = case Bytes3 of
<<2:2,_:1,2:5,_/binary>> ->
?RT_BER:decode_octet_string(Bytes3,[],[{tag,128,2,'IMPLICIT',32}], no_length, mandatory);
_ ->
{ asn1_NOVALUE, Bytes3, 0 }
end,

%%-------------------------------------------------
%% attribute number 3 with type OCTET STRING
%%-------------------------------------------------
   {Term3,Bytes5,Rb4} = ?RT_BER:decode_octet_string(Bytes4,[],[{tag,128,3,'IMPLICIT',32}], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 4 with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {Term4,Bytes6,Rb5} = case Bytes5 of
<<2:2,_:1,4:5,_/binary>> ->
?RT_BER:decode_boolean(Bytes5,[{tag,128,4,'IMPLICIT',32}], mandatory);
_ ->
{false,Bytes5, 0 }
end,

   {Bytes7,Rb6} = ?RT_BER:restbytes2(RemBytes, Bytes6,noext),
   {{'MatchingRuleAssertion', Term1, Term2, Term3, Term4}, Bytes7, Rb1+Rb2+Rb3+Rb4+Rb5+Rb6}.


%%================================
%%  SearchResultEntry
%%================================
'enc_SearchResultEntry'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,objectName), []),

%%-------------------------------------------------
%% attribute number 2   External LDAPv3:PartialAttributeList
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PartialAttributeList'(?RT_BER:cindex(3,Val,attributes), []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,64,4,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).


'dec_SearchResultEntry'(Bytes, OptOrMand) ->
   'dec_SearchResultEntry'(Bytes, OptOrMand, []).

'dec_SearchResultEntry'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,64,4,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2   External LDAPv3:PartialAttributeList
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = 'dec_PartialAttributeList'(Bytes3, mandatory, []),

   {Bytes5,Rb4} = ?RT_BER:restbytes2(RemBytes, Bytes4,noext),
   {{'SearchResultEntry', Term1, Term2}, Bytes5, Rb1+Rb2+Rb3+Rb4}.


%%================================
%%  PartialAttributeList
%%================================

'enc_PartialAttributeList'({'PartialAttributeList',Val}, TagIn) ->
   'enc_PartialAttributeList'(Val, TagIn);

'enc_PartialAttributeList'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_PartialAttributeList_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], EncBytes, EncLen).

'enc_PartialAttributeList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PartialAttributeList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PartialAttributeList_SEQOF'(H, []),
   'enc_PartialAttributeList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  PartialAttributeList_SEQOF
%%================================
'enc_PartialAttributeList_SEQOF'(Val, TagIn) ->
   
%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,type), []),

%%-------------------------------------------------
%% attribute number 2 with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PartialAttributeList_SEQOF_vals'(?RT_BER:cindex(3,Val,vals), []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).



%%================================
%%  PartialAttributeList_SEQOF_vals
%%================================

'enc_PartialAttributeList_SEQOF_vals'({'PartialAttributeList_SEQOF_vals',Val}, TagIn) ->
   'enc_PartialAttributeList_SEQOF_vals'(Val, TagIn);

'enc_PartialAttributeList_SEQOF_vals'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PartialAttributeList_SEQOF_vals_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn ++ [{tag,0,17,'IMPLICIT',32}], EncBytes, EncLen).

'enc_PartialAttributeList_SEQOF_vals_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PartialAttributeList_SEQOF_vals_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = ?RT_BER:encode_octet_string([], H, []),
   'enc_PartialAttributeList_SEQOF_vals_components'(T,[EncBytes|AccBytes], AccLen + EncLen).

'dec_PartialAttributeList_SEQOF_vals'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,17,'IMPLICIT',32}], Bytes, OptOrMand), 
   ?RT_BER:decode_components(Rb1, Len, Bytes1, fun(FBytes,_,_)->
?RT_BER:decode_octet_string(FBytes,[],[], no_length, mandatory)
end, [], []).


'dec_PartialAttributeList_SEQOF'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2 with type SET OF
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = 'dec_PartialAttributeList_SEQOF_vals'(Bytes3, mandatory, []),

   {Bytes5,Rb4} = ?RT_BER:restbytes2(RemBytes, Bytes4,noext),
   {{'PartialAttributeList_SEQOF', Term1, Term2}, Bytes5, Rb1+Rb2+Rb3+Rb4}.


'dec_PartialAttributeList'(Bytes, OptOrMand) ->
   'dec_PartialAttributeList'(Bytes, OptOrMand, []).

'dec_PartialAttributeList'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
   ?RT_BER:decode_components(Rb1, Len, Bytes1, fun 'dec_PartialAttributeList_SEQOF'/3, [], []).




%%================================
%%  SearchResultReference
%%================================

'enc_SearchResultReference'({'SearchResultReference',Val}, TagIn) ->
   'enc_SearchResultReference'(Val, TagIn);

'enc_SearchResultReference'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_SearchResultReference_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn ++ [{tag,64,19,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], EncBytes, EncLen).

'enc_SearchResultReference_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SearchResultReference_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = ?RT_BER:encode_octet_string([], H, []),
   'enc_SearchResultReference_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_SearchResultReference'(Bytes, OptOrMand) ->
   'dec_SearchResultReference'(Bytes, OptOrMand, []).

'dec_SearchResultReference'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,64,19,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
   ?RT_BER:decode_components(Rb1, Len, Bytes1, fun(FBytes,_,_)->
?RT_BER:decode_octet_string(FBytes,[],[], no_length, mandatory)
end, [], []).




%%================================
%%  SearchResultDone
%%================================

'enc_SearchResultDone'({'SearchResultDone',Val}, TagIn) ->
   'enc_SearchResultDone'(Val, TagIn);

'enc_SearchResultDone'(Val, TagIn) ->
   'enc_LDAPResult'(Val, TagIn ++ [{tag,64,5,'IMPLICIT',32}]).


'dec_SearchResultDone'(Bytes, OptOrMand) ->
   'dec_SearchResultDone'(Bytes, OptOrMand, []).

'dec_SearchResultDone'(Bytes, OptOrMand, TagIn) ->
'dec_LDAPResult'(Bytes, OptOrMand, TagIn++[{tag,64,5,'IMPLICIT',32}]).



%%================================
%%  ModifyRequest
%%================================
'enc_ModifyRequest'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,object), []),

%%-------------------------------------------------
%% attribute number 2 with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_ModifyRequest_modification'(?RT_BER:cindex(3,Val,modification), []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,64,6,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).



%%================================
%%  ModifyRequest_modification
%%================================

'enc_ModifyRequest_modification'({'ModifyRequest_modification',Val}, TagIn) ->
   'enc_ModifyRequest_modification'(Val, TagIn);

'enc_ModifyRequest_modification'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ModifyRequest_modification_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], EncBytes, EncLen).

'enc_ModifyRequest_modification_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ModifyRequest_modification_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_ModifyRequest_modification_SEQOF'(H, []),
   'enc_ModifyRequest_modification_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  ModifyRequest_modification_SEQOF
%%================================
'enc_ModifyRequest_modification_SEQOF'(Val, TagIn) ->
   
%%-------------------------------------------------
%% attribute number 1 with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case (case ?RT_BER:cindex(2,Val,operation) of {_,_}->element(2,?RT_BER:cindex(2,Val,operation));_->?RT_BER:cindex(2,Val,operation) end) of
add -> ?RT_BER:encode_enumerated(0,[]);
delete -> ?RT_BER:encode_enumerated(1,[]);
replace -> ?RT_BER:encode_enumerated(2,[]);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute number 2   External LDAPv3:AttributeTypeAndValues
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AttributeTypeAndValues'(?RT_BER:cindex(3,Val,modification), []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).
'dec_ModifyRequest_modification_SEQOF'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type ENUMERATED
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_enumerated(Bytes2,[],[{add,0},{delete,1},{replace,2}],[], mandatory),

%%-------------------------------------------------
%% attribute number 2   External LDAPv3:AttributeTypeAndValues
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = 'dec_AttributeTypeAndValues'(Bytes3, mandatory, []),

   {Bytes5,Rb4} = ?RT_BER:restbytes2(RemBytes, Bytes4,noext),
   {{'ModifyRequest_modification_SEQOF', Term1, Term2}, Bytes5, Rb1+Rb2+Rb3+Rb4}.
'dec_ModifyRequest_modification'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
   ?RT_BER:decode_components(Rb1, Len, Bytes1, fun 'dec_ModifyRequest_modification_SEQOF'/3, [], []).




'dec_ModifyRequest'(Bytes, OptOrMand) ->
   'dec_ModifyRequest'(Bytes, OptOrMand, []).

'dec_ModifyRequest'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,64,6,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2 with type SEQUENCE OF
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = 'dec_ModifyRequest_modification'(Bytes3, mandatory, []),

   {Bytes5,Rb4} = ?RT_BER:restbytes2(RemBytes, Bytes4,noext),
   {{'ModifyRequest', Term1, Term2}, Bytes5, Rb1+Rb2+Rb3+Rb4}.


%%================================
%%  AttributeTypeAndValues
%%================================
'enc_AttributeTypeAndValues'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,type), []),

%%-------------------------------------------------
%% attribute number 2 with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AttributeTypeAndValues_vals'(?RT_BER:cindex(3,Val,vals), []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).



%%================================
%%  AttributeTypeAndValues_vals
%%================================

'enc_AttributeTypeAndValues_vals'({'AttributeTypeAndValues_vals',Val}, TagIn) ->
   'enc_AttributeTypeAndValues_vals'(Val, TagIn);

'enc_AttributeTypeAndValues_vals'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_AttributeTypeAndValues_vals_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn ++ [{tag,0,17,'IMPLICIT',32}], EncBytes, EncLen).

'enc_AttributeTypeAndValues_vals_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttributeTypeAndValues_vals_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = ?RT_BER:encode_octet_string([], H, []),
   'enc_AttributeTypeAndValues_vals_components'(T,[EncBytes|AccBytes], AccLen + EncLen).

'dec_AttributeTypeAndValues_vals'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,17,'IMPLICIT',32}], Bytes, OptOrMand), 
   ?RT_BER:decode_components(Rb1, Len, Bytes1, fun(FBytes,_,_)->
?RT_BER:decode_octet_string(FBytes,[],[], no_length, mandatory)
end, [], []).




'dec_AttributeTypeAndValues'(Bytes, OptOrMand) ->
   'dec_AttributeTypeAndValues'(Bytes, OptOrMand, []).

'dec_AttributeTypeAndValues'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2 with type SET OF
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = 'dec_AttributeTypeAndValues_vals'(Bytes3, mandatory, []),

   {Bytes5,Rb4} = ?RT_BER:restbytes2(RemBytes, Bytes4,noext),
   {{'AttributeTypeAndValues', Term1, Term2}, Bytes5, Rb1+Rb2+Rb3+Rb4}.


%%================================
%%  ModifyResponse
%%================================

'enc_ModifyResponse'({'ModifyResponse',Val}, TagIn) ->
   'enc_ModifyResponse'(Val, TagIn);

'enc_ModifyResponse'(Val, TagIn) ->
   'enc_LDAPResult'(Val, TagIn ++ [{tag,64,7,'IMPLICIT',32}]).


'dec_ModifyResponse'(Bytes, OptOrMand) ->
   'dec_ModifyResponse'(Bytes, OptOrMand, []).

'dec_ModifyResponse'(Bytes, OptOrMand, TagIn) ->
'dec_LDAPResult'(Bytes, OptOrMand, TagIn++[{tag,64,7,'IMPLICIT',32}]).



%%================================
%%  AddRequest
%%================================
'enc_AddRequest'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,entry), []),

%%-------------------------------------------------
%% attribute number 2   External LDAPv3:AttributeList
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AttributeList'(?RT_BER:cindex(3,Val,attributes), []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,64,8,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).


'dec_AddRequest'(Bytes, OptOrMand) ->
   'dec_AddRequest'(Bytes, OptOrMand, []).

'dec_AddRequest'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,64,8,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2   External LDAPv3:AttributeList
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = 'dec_AttributeList'(Bytes3, mandatory, []),

   {Bytes5,Rb4} = ?RT_BER:restbytes2(RemBytes, Bytes4,noext),
   {{'AddRequest', Term1, Term2}, Bytes5, Rb1+Rb2+Rb3+Rb4}.


%%================================
%%  AttributeList
%%================================

'enc_AttributeList'({'AttributeList',Val}, TagIn) ->
   'enc_AttributeList'(Val, TagIn);

'enc_AttributeList'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_AttributeList_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], EncBytes, EncLen).

'enc_AttributeList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttributeList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AttributeList_SEQOF'(H, []),
   'enc_AttributeList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  AttributeList_SEQOF
%%================================
'enc_AttributeList_SEQOF'(Val, TagIn) ->
   
%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,type), []),

%%-------------------------------------------------
%% attribute number 2 with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AttributeList_SEQOF_vals'(?RT_BER:cindex(3,Val,vals), []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).



%%================================
%%  AttributeList_SEQOF_vals
%%================================

'enc_AttributeList_SEQOF_vals'({'AttributeList_SEQOF_vals',Val}, TagIn) ->
   'enc_AttributeList_SEQOF_vals'(Val, TagIn);

'enc_AttributeList_SEQOF_vals'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_AttributeList_SEQOF_vals_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn ++ [{tag,0,17,'IMPLICIT',32}], EncBytes, EncLen).

'enc_AttributeList_SEQOF_vals_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttributeList_SEQOF_vals_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = ?RT_BER:encode_octet_string([], H, []),
   'enc_AttributeList_SEQOF_vals_components'(T,[EncBytes|AccBytes], AccLen + EncLen).

'dec_AttributeList_SEQOF_vals'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,17,'IMPLICIT',32}], Bytes, OptOrMand), 
   ?RT_BER:decode_components(Rb1, Len, Bytes1, fun(FBytes,_,_)->
?RT_BER:decode_octet_string(FBytes,[],[], no_length, mandatory)
end, [], []).


'dec_AttributeList_SEQOF'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2 with type SET OF
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = 'dec_AttributeList_SEQOF_vals'(Bytes3, mandatory, []),

   {Bytes5,Rb4} = ?RT_BER:restbytes2(RemBytes, Bytes4,noext),
   {{'AttributeList_SEQOF', Term1, Term2}, Bytes5, Rb1+Rb2+Rb3+Rb4}.


'dec_AttributeList'(Bytes, OptOrMand) ->
   'dec_AttributeList'(Bytes, OptOrMand, []).

'dec_AttributeList'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
   ?RT_BER:decode_components(Rb1, Len, Bytes1, fun 'dec_AttributeList_SEQOF'/3, [], []).




%%================================
%%  AddResponse
%%================================

'enc_AddResponse'({'AddResponse',Val}, TagIn) ->
   'enc_AddResponse'(Val, TagIn);

'enc_AddResponse'(Val, TagIn) ->
   'enc_LDAPResult'(Val, TagIn ++ [{tag,64,9,'IMPLICIT',32}]).


'dec_AddResponse'(Bytes, OptOrMand) ->
   'dec_AddResponse'(Bytes, OptOrMand, []).

'dec_AddResponse'(Bytes, OptOrMand, TagIn) ->
'dec_LDAPResult'(Bytes, OptOrMand, TagIn++[{tag,64,9,'IMPLICIT',32}]).



%%================================
%%  DelRequest
%%================================

'enc_DelRequest'({'DelRequest',Val}, TagIn) ->
   'enc_DelRequest'(Val, TagIn);

'enc_DelRequest'(Val, TagIn) ->
?RT_BER:encode_octet_string([], Val, TagIn ++ [{tag,64,10,'IMPLICIT',32}]).


'dec_DelRequest'(Bytes, OptOrMand) ->
   'dec_DelRequest'(Bytes, OptOrMand, []).

'dec_DelRequest'(Bytes, OptOrMand, TagIn) ->
?RT_BER:decode_octet_string(Bytes,[],TagIn++[{tag,64,10,'IMPLICIT',32}], no_length, OptOrMand).



%%================================
%%  DelResponse
%%================================

'enc_DelResponse'({'DelResponse',Val}, TagIn) ->
   'enc_DelResponse'(Val, TagIn);

'enc_DelResponse'(Val, TagIn) ->
   'enc_LDAPResult'(Val, TagIn ++ [{tag,64,11,'IMPLICIT',32}]).


'dec_DelResponse'(Bytes, OptOrMand) ->
   'dec_DelResponse'(Bytes, OptOrMand, []).

'dec_DelResponse'(Bytes, OptOrMand, TagIn) ->
'dec_LDAPResult'(Bytes, OptOrMand, TagIn++[{tag,64,11,'IMPLICIT',32}]).



%%================================
%%  ModifyDNRequest
%%================================
'enc_ModifyDNRequest'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,entry), []),

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(3,Val,newrdn), []),

%%-------------------------------------------------
%% attribute number 3 with type BOOLEAN
%%-------------------------------------------------
   {EncBytes3,EncLen3} = ?RT_BER:encode_boolean(?RT_BER:cindex(4,Val,deleteoldrdn), []),

%%-------------------------------------------------
%% attribute number 4 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case ?RT_BER:cindex(5,Val,newSuperior) of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_octet_string([], ?RT_BER:cindex(5,Val,newSuperior), [{tag,128,0,'IMPLICIT',32}])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,64,12,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).


'dec_ModifyDNRequest'(Bytes, OptOrMand) ->
   'dec_ModifyDNRequest'(Bytes, OptOrMand, []).

'dec_ModifyDNRequest'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,64,12,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = ?RT_BER:decode_octet_string(Bytes3,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 3 with type BOOLEAN
%%-------------------------------------------------
   {Term3,Bytes5,Rb4} = ?RT_BER:decode_boolean(Bytes4,[], mandatory),

%%-------------------------------------------------
%% attribute number 4 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {Term4,Bytes6,Rb5} = case Bytes5 of
<<2:2,_:1,0:5,_/binary>> ->
?RT_BER:decode_octet_string(Bytes5,[],[{tag,128,0,'IMPLICIT',32}], no_length, mandatory);
_ ->
{ asn1_NOVALUE, Bytes5, 0 }
end,

   {Bytes7,Rb6} = ?RT_BER:restbytes2(RemBytes, Bytes6,noext),
   {{'ModifyDNRequest', Term1, Term2, Term3, Term4}, Bytes7, Rb1+Rb2+Rb3+Rb4+Rb5+Rb6}.


%%================================
%%  ModifyDNResponse
%%================================

'enc_ModifyDNResponse'({'ModifyDNResponse',Val}, TagIn) ->
   'enc_ModifyDNResponse'(Val, TagIn);

'enc_ModifyDNResponse'(Val, TagIn) ->
   'enc_LDAPResult'(Val, TagIn ++ [{tag,64,13,'IMPLICIT',32}]).


'dec_ModifyDNResponse'(Bytes, OptOrMand) ->
   'dec_ModifyDNResponse'(Bytes, OptOrMand, []).

'dec_ModifyDNResponse'(Bytes, OptOrMand, TagIn) ->
'dec_LDAPResult'(Bytes, OptOrMand, TagIn++[{tag,64,13,'IMPLICIT',32}]).



%%================================
%%  CompareRequest
%%================================
'enc_CompareRequest'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,entry), []),

%%-------------------------------------------------
%% attribute number 2   External LDAPv3:AttributeValueAssertion
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AttributeValueAssertion'(?RT_BER:cindex(3,Val,ava), []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,64,14,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).


'dec_CompareRequest'(Bytes, OptOrMand) ->
   'dec_CompareRequest'(Bytes, OptOrMand, []).

'dec_CompareRequest'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,64,14,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2   External LDAPv3:AttributeValueAssertion
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = 'dec_AttributeValueAssertion'(Bytes3, mandatory, []),

   {Bytes5,Rb4} = ?RT_BER:restbytes2(RemBytes, Bytes4,noext),
   {{'CompareRequest', Term1, Term2}, Bytes5, Rb1+Rb2+Rb3+Rb4}.


%%================================
%%  CompareResponse
%%================================

'enc_CompareResponse'({'CompareResponse',Val}, TagIn) ->
   'enc_CompareResponse'(Val, TagIn);

'enc_CompareResponse'(Val, TagIn) ->
   'enc_LDAPResult'(Val, TagIn ++ [{tag,64,15,'IMPLICIT',32}]).


'dec_CompareResponse'(Bytes, OptOrMand) ->
   'dec_CompareResponse'(Bytes, OptOrMand, []).

'dec_CompareResponse'(Bytes, OptOrMand, TagIn) ->
'dec_LDAPResult'(Bytes, OptOrMand, TagIn++[{tag,64,15,'IMPLICIT',32}]).



%%================================
%%  AbandonRequest
%%================================

'enc_AbandonRequest'({'AbandonRequest',Val}, TagIn) ->
   'enc_AbandonRequest'(Val, TagIn);

'enc_AbandonRequest'(Val, TagIn) ->
?RT_BER:encode_integer([], Val, TagIn ++ [{tag,64,16,'IMPLICIT',32}]).


'dec_AbandonRequest'(Bytes, OptOrMand) ->
   'dec_AbandonRequest'(Bytes, OptOrMand, []).

'dec_AbandonRequest'(Bytes, OptOrMand, TagIn) ->
?RT_BER:decode_integer(Bytes,{0,2147483647},TagIn++[{tag,64,16,'IMPLICIT',32}], OptOrMand).



%%================================
%%  ExtendedRequest
%%================================
'enc_ExtendedRequest'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(2,Val,requestName), [{tag,128,0,'IMPLICIT',32}]),

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case ?RT_BER:cindex(3,Val,requestValue) of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_octet_string([], ?RT_BER:cindex(3,Val,requestValue), [{tag,128,1,'IMPLICIT',32}])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,64,23,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).


'dec_ExtendedRequest'(Bytes, OptOrMand) ->
   'dec_ExtendedRequest'(Bytes, OptOrMand, []).

'dec_ExtendedRequest'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,64,23,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type OCTET STRING
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_octet_string(Bytes2,[],[{tag,128,0,'IMPLICIT',32}], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = case Bytes3 of
<<2:2,_:1,1:5,_/binary>> ->
?RT_BER:decode_octet_string(Bytes3,[],[{tag,128,1,'IMPLICIT',32}], no_length, mandatory);
_ ->
{ asn1_NOVALUE, Bytes3, 0 }
end,

   {Bytes5,Rb4} = ?RT_BER:restbytes2(RemBytes, Bytes4,noext),
   {{'ExtendedRequest', Term1, Term2}, Bytes5, Rb1+Rb2+Rb3+Rb4}.


%%================================
%%  ExtendedResponse
%%================================
'enc_ExtendedResponse'(Val, TagIn) ->

%%-------------------------------------------------
%% attribute number 1 with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case (case ?RT_BER:cindex(2,Val,resultCode) of {_,_}->element(2,?RT_BER:cindex(2,Val,resultCode));_->?RT_BER:cindex(2,Val,resultCode) end) of
success -> ?RT_BER:encode_enumerated(0,[]);
operationsError -> ?RT_BER:encode_enumerated(1,[]);
protocolError -> ?RT_BER:encode_enumerated(2,[]);
timeLimitExceeded -> ?RT_BER:encode_enumerated(3,[]);
sizeLimitExceeded -> ?RT_BER:encode_enumerated(4,[]);
compareFalse -> ?RT_BER:encode_enumerated(5,[]);
compareTrue -> ?RT_BER:encode_enumerated(6,[]);
authMethodNotSupported -> ?RT_BER:encode_enumerated(7,[]);
strongAuthRequired -> ?RT_BER:encode_enumerated(8,[]);
referral -> ?RT_BER:encode_enumerated(10,[]);
adminLimitExceeded -> ?RT_BER:encode_enumerated(11,[]);
unavailableCriticalExtension -> ?RT_BER:encode_enumerated(12,[]);
confidentialityRequired -> ?RT_BER:encode_enumerated(13,[]);
saslBindInProgress -> ?RT_BER:encode_enumerated(14,[]);
noSuchAttribute -> ?RT_BER:encode_enumerated(16,[]);
undefinedAttributeType -> ?RT_BER:encode_enumerated(17,[]);
inappropriateMatching -> ?RT_BER:encode_enumerated(18,[]);
constraintViolation -> ?RT_BER:encode_enumerated(19,[]);
attributeOrValueExists -> ?RT_BER:encode_enumerated(20,[]);
invalidAttributeSyntax -> ?RT_BER:encode_enumerated(21,[]);
noSuchObject -> ?RT_BER:encode_enumerated(32,[]);
aliasProblem -> ?RT_BER:encode_enumerated(33,[]);
invalidDNSyntax -> ?RT_BER:encode_enumerated(34,[]);
aliasDereferencingProblem -> ?RT_BER:encode_enumerated(36,[]);
inappropriateAuthentication -> ?RT_BER:encode_enumerated(48,[]);
invalidCredentials -> ?RT_BER:encode_enumerated(49,[]);
insufficientAccessRights -> ?RT_BER:encode_enumerated(50,[]);
busy -> ?RT_BER:encode_enumerated(51,[]);
unavailable -> ?RT_BER:encode_enumerated(52,[]);
unwillingToPerform -> ?RT_BER:encode_enumerated(53,[]);
loopDetect -> ?RT_BER:encode_enumerated(54,[]);
namingViolation -> ?RT_BER:encode_enumerated(64,[]);
objectClassViolation -> ?RT_BER:encode_enumerated(65,[]);
notAllowedOnNonLeaf -> ?RT_BER:encode_enumerated(66,[]);
notAllowedOnRDN -> ?RT_BER:encode_enumerated(67,[]);
entryAlreadyExists -> ?RT_BER:encode_enumerated(68,[]);
objectClassModsProhibited -> ?RT_BER:encode_enumerated(69,[]);
affectsMultipleDSAs -> ?RT_BER:encode_enumerated(71,[]);
other -> ?RT_BER:encode_enumerated(80,[]);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(3,Val,matchedDN), []),

%%-------------------------------------------------
%% attribute number 3 with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = ?RT_BER:encode_octet_string([], ?RT_BER:cindex(4,Val,errorMessage), []),

%%-------------------------------------------------
%% attribute number 4   External LDAPv3:Referral OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case ?RT_BER:cindex(5,Val,referral) of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Referral'(?RT_BER:cindex(5,Val,referral), [{tag,128,3,'IMPLICIT',32}])
       end,

%%-------------------------------------------------
%% attribute number 5 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case ?RT_BER:cindex(6,Val,responseName) of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_octet_string([], ?RT_BER:cindex(6,Val,responseName), [{tag,128,10,'IMPLICIT',32}])
       end,

%%-------------------------------------------------
%% attribute number 6 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case ?RT_BER:cindex(7,Val,response) of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_octet_string([], ?RT_BER:cindex(7,Val,response), [{tag,128,11,'IMPLICIT',32}])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6,
{TagBytes,Len} = ?RT_BER:encode_tags(TagIn ++ [{tag,64,24,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], BytesSoFar, LenSoFar).


'dec_ExtendedResponse'(Bytes, OptOrMand) ->
   'dec_ExtendedResponse'(Bytes, OptOrMand, []).

'dec_ExtendedResponse'(Bytes, OptOrMand, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
   {{_,Len},Bytes1,Rb1} = ?RT_BER:check_tags(TagIn ++ [{tag,64,24,'IMPLICIT',32},{tag,0,16,'IMPLICIT',32}], Bytes, OptOrMand), 
{Bytes2,RemBytes} = ?RT_BER:split_list(Bytes1,Len),

%%-------------------------------------------------
%% attribute number 1 with type ENUMERATED
%%-------------------------------------------------
   {Term1,Bytes3,Rb2} = ?RT_BER:decode_enumerated(Bytes2,[],[{success,0},{operationsError,1},{protocolError,2},{timeLimitExceeded,3},{sizeLimitExceeded,4},{compareFalse,5},{compareTrue,6},{authMethodNotSupported,7},{strongAuthRequired,8},{referral,10},{adminLimitExceeded,11},{unavailableCriticalExtension,12},{confidentialityRequired,13},{saslBindInProgress,14},{noSuchAttribute,16},{undefinedAttributeType,17},{inappropriateMatching,18},{constraintViolation,19},{attributeOrValueExists,20},{invalidAttributeSyntax,21},{noSuchObject,32},{aliasProblem,33},{invalidDNSyntax,34},{aliasDereferencingProblem,36},{inappropriateAuthentication,48},{invalidCredentials,49},{insufficientAccessRights,50},{busy,51},{unavailable,52},{unwillingToPerform,53},{loopDetect,54},{namingViolation,64},{objectClassViolation,65},{notAllowedOnNonLeaf,66},{notAllowedOnRDN,67},{entryAlreadyExists,68},{objectClassModsProhibited,69},{affectsMultipleDSAs,71},{other,80}],[], mandatory),

%%-------------------------------------------------
%% attribute number 2 with type OCTET STRING
%%-------------------------------------------------
   {Term2,Bytes4,Rb3} = ?RT_BER:decode_octet_string(Bytes3,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 3 with type OCTET STRING
%%-------------------------------------------------
   {Term3,Bytes5,Rb4} = ?RT_BER:decode_octet_string(Bytes4,[],[], no_length, mandatory),

%%-------------------------------------------------
%% attribute number 4   External LDAPv3:Referral OPTIONAL
%%-------------------------------------------------
   {Term4,Bytes6,Rb5} = case Bytes5 of
<<2:2,_:1,3:5,_/binary>> ->
'dec_Referral'(Bytes5, opt_or_default, [{tag,128,3,'IMPLICIT',32}]);
_ ->
{ asn1_NOVALUE, Bytes5, 0 }
end,

%%-------------------------------------------------
%% attribute number 5 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {Term5,Bytes7,Rb6} = case Bytes6 of
<<2:2,_:1,10:5,_/binary>> ->
?RT_BER:decode_octet_string(Bytes6,[],[{tag,128,10,'IMPLICIT',32}], no_length, mandatory);
_ ->
{ asn1_NOVALUE, Bytes6, 0 }
end,

%%-------------------------------------------------
%% attribute number 6 with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {Term6,Bytes8,Rb7} = case Bytes7 of
<<2:2,_:1,11:5,_/binary>> ->
?RT_BER:decode_octet_string(Bytes7,[],[{tag,128,11,'IMPLICIT',32}], no_length, mandatory);
_ ->
{ asn1_NOVALUE, Bytes7, 0 }
end,

   {Bytes9,Rb8} = ?RT_BER:restbytes2(RemBytes, Bytes8,noext),
   {{'ExtendedResponse', Term1, Term2, Term3, Term4, Term5, Term6}, Bytes9, Rb1+Rb2+Rb3+Rb4+Rb5+Rb6+Rb7+Rb8}.
'maxInt'() ->
2147483647.

