#ifndef _STATUS_STATUS_H
#define _STATUS_STATUS_H

#include "const.h"

typedef unsigned int	ux32;
typedef unsigned short	ux16;
typedef unsigned char	ux8;

typedef signed int	sx32;
typedef signed short	sx16;
typedef signed char	sx8;


#define MAX_MATCHES	256
#define STATUS_PORTNO	3749
#define STATUS_PORTSTR	"3749"


struct player_info {
	int	matchno;
	int	id;
	ux8	team;
	ux8	namelen;
	ux8	name[MAX_CHARS];
	sx16	score;
	ux16	last_kills;
	ux16	last_deaths;
	ux16	total_kills;
	ux16	total_deaths;
};


struct match_info {
	ux32	inet_addr;
	char	addr_str[16];
	int	matchno;
	int	finished;
	int	inited;
	int	lastround;
	int	lastwinner;
	int	fd;
	char	t2name[MAX_CHARS];
	char	t4name[MAX_CHARS];
	ux8	t2players;
	ux8	t4players;
	sx16	t2score;
	sx16	t4score;
	struct player_info *team2;
	struct player_info *team4;
};


#define INIT_MATCH_MAGIC	0xada0
#define END_MATCH_MAGIC		0x6daf
#define ROUND_END_MAGIC		0x0f41
#define INIT_PLAYER_MAGIC	0xfeed
#define PLAYER_STATUS_MAGIC	0xa537

struct match_init {
	ux16	magic;
	ux16	matchno;
	ux8	t2players;
	ux8	t4players;
	ux8	pad[2];
};


struct match_end {
	ux16	magic;
	ux16	matchno;
};


struct player_init {
	ux16	magic;
	ux16	id;
	ux8	team;
	ux8	namelen;
	ux8	pad[2];
	/* Name here */
};


struct round_end {
	ux16	magic;
	ux8	roundno;
	ux8	winner;
	ux8	by;
#define	BY_DRAW		0
#define BY_BALL		1
#define BY_ALIVE	2
	ux8	pad[3];
};


struct player_status {
	ux16	magic;
	ux16	id;
	sx16	score;
	ux8	kills;
	ux8	deaths;
};

#endif /* _STATUS_STATUS_H */
